/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of sets with user defined {@link org.eclipse.collections.api.block.HashingStrategy}s.
 * <p>
 *     This package contains one implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy} - a set with user defined {@link org.eclipse.collections.api.block.HashingStrategy}.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.strategy.mutable.MutableHashingStrategySetFactoryImpl} - a factory which creates instances of type {@link org.eclipse.collections.api.set.MutableSet} with user defined hashing strategy.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.set.strategy.mutable;
