/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableBooleanListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.impl.factory.primitive.BooleanLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanSingletonList;

public enum ImmutableBooleanListFactoryImpl implements ImmutableBooleanListFactory
{
    INSTANCE;


    @Override
    public ImmutableBooleanList empty() {
        return ImmutableBooleanEmptyList.INSTANCE;
    }

    @Override
    public ImmutableBooleanList of() {
        return this.empty();
    }

    @Override
    public ImmutableBooleanList with() {
        return this.empty();
    }

    @Override
    public ImmutableBooleanList of(boolean one) {
        return this.with(one);
    }

    @Override
    public ImmutableBooleanList with(boolean one) {
        return new ImmutableBooleanSingletonList(one);
    }

    @Override
    public ImmutableBooleanList of(boolean ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableBooleanList with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableBooleanArrayList.newListWith(items);
    }

    @Override
    public ImmutableBooleanList ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableBooleanList withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanList) {
            return (ImmutableBooleanList)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableBooleanList ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableBooleanList withAll(Iterable<Boolean> iterable) {
        return BooleanLists.mutable.withAll(iterable).toImmutable();
    }
}

