/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanBooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;

public abstract class AbstractSynchronizedBooleanCollection
implements MutableBooleanCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableBooleanCollection collection;

    protected AbstractSynchronizedBooleanCollection(MutableBooleanCollection collection) {
        this(collection, null);
    }

    protected AbstractSynchronizedBooleanCollection(MutableBooleanCollection collection, Object newLock) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractSynchronizedBooleanCollection on a null collection");
        }
        this.collection = collection;
        this.lock = newLock == null ? this : newLock;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected MutableBooleanCollection getBooleanCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanCollection select(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collect((BooleanToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanCollection with(boolean element) {
        Object object = this.lock;
        synchronized (object) {
            this.add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanCollection without(boolean element) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanCollection withAll(BooleanIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.addAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanCollection withoutAll(BooleanIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableBooleanCollection asUnmodifiable() {
        return new UnmodifiableBooleanCollection(this);
    }

    @Override
    public MutableBooleanCollection asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBooleanCollection toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toImmutable();
        }
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(boolean newItem) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.add(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    @Override
    public MutableBooleanIterator booleanIterator() {
        return this.collection.booleanIterator();
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(BooleanProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBooleanBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(BooleanBooleanToBooleanFunction accumulator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reduce(accumulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduceIfEmpty(BooleanBooleanToBooleanFunction accumulator, boolean defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reduceIfEmpty(accumulator, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<BooleanIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.chunk(size);
        }
    }
}

