/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableBooleanListFactory;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.impl.factory.primitive.BooleanLists;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableBooleanListFactoryImpl implements MutableBooleanListFactory
{
    INSTANCE;


    @Override
    public MutableBooleanList empty() {
        return new BooleanArrayList();
    }

    @Override
    public MutableBooleanList of() {
        return this.empty();
    }

    @Override
    public MutableBooleanList with() {
        return this.empty();
    }

    @Override
    public MutableBooleanList of(boolean ... items) {
        return this.with(items);
    }

    @Override
    public MutableBooleanList with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return BooleanArrayList.newListWith(items);
    }

    @Override
    public MutableBooleanList ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableBooleanList withAll(BooleanIterable items) {
        return BooleanArrayList.newList(items);
    }

    @Override
    public MutableBooleanList ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableBooleanList withAll(Iterable<Boolean> iterable) {
        return Iterate.collectBoolean(iterable, Boolean::booleanValue, BooleanLists.mutable.empty());
    }
}

