/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableCharListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharSingletonList;

public enum ImmutableCharListFactoryImpl implements ImmutableCharListFactory
{
    INSTANCE;


    @Override
    public ImmutableCharList empty() {
        return ImmutableCharEmptyList.INSTANCE;
    }

    @Override
    public ImmutableCharList of() {
        return this.empty();
    }

    @Override
    public ImmutableCharList with() {
        return this.empty();
    }

    @Override
    public ImmutableCharList of(char one) {
        return this.with(one);
    }

    @Override
    public ImmutableCharList with(char one) {
        return new ImmutableCharSingletonList(one);
    }

    @Override
    public ImmutableCharList of(char ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableCharList with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayList.newListWith(items);
    }

    @Override
    public ImmutableCharList ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableCharList withAll(CharIterable items) {
        if (items instanceof ImmutableCharList) {
            return (ImmutableCharList)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableCharList ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableCharList withAll(Iterable<Character> iterable) {
        return CharLists.mutable.withAll(iterable).toImmutable();
    }
}

