/*
 * Copyright (c) 2018 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.map.primitive.MutableFloatByteMap;
import org.eclipse.collections.api.map.primitive.FloatByteMap;

/**
 * A factory which creates instances of type {@link MutableFloatByteMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableFloatByteMapFactory
{
    MutableFloatByteMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableFloatByteMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableFloatByteMap with();

    /**
     * Same as {@link #withAll(FloatByteMap)}.
     */
    MutableFloatByteMap ofAll(FloatByteMap map);

    MutableFloatByteMap withAll(FloatByteMap map);

    /**
     * Creates an {@code MutableFloatByteMap} from an {@code Iterable<T>} by applying {@code keyFunction} and {@code valueFunction}.
     *
     * @since 10.0
     */
    <T> MutableFloatByteMap from(Iterable<T> iterable, FloatFunction<? super T> keyFunction, ByteFunction<? super T> valueFunction);
}
