/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tradeoffAnalysis.dialogs;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;

public class ConfigurationSelectionDialog
extends Dialog {
    public static String CHECK_CONTRACT_REFINEMENT = "Check Contract Refinement";
    private Combo checkType;
    private String selectedCheckType;
    private Table configurationsTable;
    private EList<InstantiatedArchitectureConfiguration> selectedConfigurations;
    private Class rootComponent;
    private boolean goAhead;

    public ConfigurationSelectionDialog(Class rootComponent) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(48);
        this.rootComponent = rootComponent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Trade-off Analysis");
    }

    protected void okPressed() {
        TableItem[] tableItems;
        this.selectedCheckType = this.checkType.getText();
        this.selectedConfigurations = new BasicEList();
        TableItem[] tableItemArray = tableItems = this.configurationsTable.getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            Property property;
            Stereotype stereotype;
            TableItem item = tableItemArray[n2];
            if (item.getChecked() && (stereotype = (property = this.rootComponent.getOwnedAttribute(item.getText(), null)).getAppliedStereotype("CHESS::ParameterizedArchitecture::InstantiatedArchitectureConfiguration")) != null) {
                this.selectedConfigurations.add((Object)((InstantiatedArchitectureConfiguration)property.getStereotypeApplication(stereotype)));
            }
            ++n2;
        }
        this.goAhead = true;
        super.okPressed();
    }

    private void populateConfigurationsTable(Table configurationsTable, Class rootComponent) {
        EList properties = rootComponent.getOwnedAttributes();
        for (Property property : properties) {
            if (property.getAppliedStereotype("CHESS::ParameterizedArchitecture::InstantiatedArchitectureConfiguration") == null) continue;
            TableItem item = new TableItem(configurationsTable, 0);
            item.setText(property.getName());
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Composite validationContainer = new Composite(container, 0);
        validationContainer.setLayout((Layout)gridLayout);
        validationContainer.setLayoutData((Object)gridData);
        Label labelCheckType = new Label(validationContainer, 16384);
        labelCheckType.setText("Check Type");
        this.checkType = new Combo(validationContainer, 8);
        this.checkType.add(CHECK_CONTRACT_REFINEMENT);
        this.checkType.select(0);
        Label labelConfigurations = new Label(validationContainer, 16384);
        labelConfigurations.setText("Available Configurations");
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 240;
        this.configurationsTable = new Table(validationContainer, 2848);
        this.configurationsTable.setLayoutData((Object)gridData);
        this.populateConfigurationsTable(this.configurationsTable, this.rootComponent);
        this.configurationsTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItems;
                int checked = 0;
                TableItem[] tableItemArray = tableItems = ConfigurationSelectionDialog.this.configurationsTable.getItems();
                int n = tableItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        ++checked;
                    }
                    ++n2;
                }
                if (checked > 1) {
                    ConfigurationSelectionDialog.this.getButton(0).setEnabled(true);
                } else {
                    ConfigurationSelectionDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public EList<InstantiatedArchitectureConfiguration> getConfigurations() {
        return this.selectedConfigurations;
    }

    public String getCheckType() {
        return this.selectedCheckType;
    }
}

