/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.internal.service;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.resourcelistener.ResourceSetListenerManager;
import org.polarsys.chess.core.resourcelistener.SelectionListenerManager;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.internal.Activator;

public class CHESSService {
    private static final String ICON_LOCATION = "org.polarsys.chess.service";
    public static Hashtable<String, ImageDescriptor> viewIcons = new Hashtable();
    private ISashWindowsContainer container;
    private ServicesRegistry serviceRegistry;
    private DiagramStatus diagramStatus;
    private SelectionListenerManager selectionListener;
    private ResourceSetListenerManager resourceListener;
    private TransactionalEditingDomain editingDomain;
    private IEditorPart currentEditor;
    private IWorkbenchPage currentPage;

    public CHESSService(ISashWindowsContainer container, ServicesRegistry registry) {
        this.container = container;
        this.serviceRegistry = registry;
    }

    public boolean start(IWorkbenchPart part) {
        IEditorPart activeEditor = this.container.getActiveEditor();
        if (activeEditor != null && CHESSEditorUtils.isCHESSProject(activeEditor)) {
            this.initializeCHESS(activeEditor);
            return true;
        }
        if (activeEditor == null) {
            try {
                if (part instanceof PapyrusMultiDiagramEditor) {
                    PapyrusMultiDiagramEditor editor = (PapyrusMultiDiagramEditor)part;
                    this.serviceRegistry = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
                    this.container = (ISashWindowsContainer)this.serviceRegistry.getService(ISashWindowsContainer.class);
                    if (CHESSEditorUtils.isCHESSProject((IEditorPart)editor)) {
                        this.initializeCHESS((IEditorPart)editor);
                        return true;
                    }
                }
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    private void initializeCHESS(IEditorPart activeEditor) {
        ModelSet modelSet = null;
        try {
            modelSet = (ModelSet)this.serviceRegistry.getService(ModelSet.class);
            this.container = (ISashWindowsContainer)activeEditor.getAdapter(ISashWindowsContainer.class);
            if (this.container == null) {
                this.container = (ISashWindowsContainer)this.serviceRegistry.getService(ISashWindowsContainer.class);
            }
            this.diagramStatus = new DiagramStatus(this.container.getActiveSashWindowsPage());
            this.editingDomain = modelSet.getTransactionalEditingDomain();
            CHESSProfileManager.loadCHESSProfile((ResourceSet)this.editingDomain.getResourceSet());
            CHESSProfileManager.loadExternalProfiles((ResourceSet)this.editingDomain.getResourceSet());
            this.resourceListener = new ResourceSetListenerManager(this.serviceRegistry);
            this.editingDomain.addResourceSetListener((ResourceSetListener)this.resourceListener);
            this.selectionListener = new SelectionListenerManager(this.serviceRegistry);
            this.currentEditor = activeEditor;
            this.currentPage = this.currentEditor.getSite().getPage();
            this.currentPage.addSelectionListener((ISelectionListener)this.selectionListener);
            this.loadIcons();
            CHESSEditorUtils.cleanAllDiagrams();
            Activator.info("CHESS Service has been initialized.");
        }
        catch (ServiceException e) {
            Activator.error("Errors during CHESS service initialization", e);
        }
    }

    public void stopService() {
        this.currentPage.removeSelectionListener((ISelectionListener)this.selectionListener);
        this.editingDomain.removeResourceSetListener((ResourceSetListener)this.resourceListener);
        Activator.info("CHESS Service has been terminated.");
    }

    private void loadIcons() {
        if (!viewIcons.keySet().isEmpty()) {
            return;
        }
        URL nullFile = FileLocator.find((Bundle)Platform.getBundle((String)ICON_LOCATION), (IPath)new Path("icons/NullView.gif"), null);
        ImageDescriptor icon = ImageDescriptor.createFromURL((URL)nullFile);
        viewIcons.put("NullView", icon);
        for (String v : CHESSProfileManager.CHESS_VIEWS_LIST) {
            URL file = FileLocator.find((Bundle)Platform.getBundle((String)ICON_LOCATION), (IPath)new Path("icons/" + v + ".gif"), null);
            icon = file != null ? ImageDescriptor.createFromURL((URL)file) : ImageDescriptor.createFromURL((URL)nullFile);
            viewIcons.put(v, icon);
        }
    }

    public void unload() {
    }

    public DiagramStatus getDiagramStatus() {
        return this.diagramStatus;
    }
}

