/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.gui.utils;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StateMachine;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.exceptions.NoComponentException;

public class SelectionUtil {
    private static final Logger logger = Logger.getLogger(SelectionUtil.class);
    private static SelectionUtil selectionUtil;
    private ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private EntityUtil entityUtil = EntityUtil.getInstance();

    public static SelectionUtil getInstance() {
        if (selectionUtil == null) {
            selectionUtil = new SelectionUtil();
        }
        return selectionUtil;
    }

    public Object getUmlSelectedObject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        return this.getUmlSelectedObject(selection);
    }

    public Object getUmlSelectedObject(Object selection) {
        EObject selectedEObject;
        List selectionList;
        Object selectedObject = selection;
        if (selectedObject instanceof IStructuredSelection && (selectionList = ((IStructuredSelection)selectedObject).toList()).size() == 1) {
            selectedObject = selectionList.get(0);
        }
        if ((selectedEObject = EMFHelper.getEObject((Object)selectedObject)) != null) {
            selectedObject = selectedEObject;
        }
        if (selectedObject instanceof GraphicalEditPart) {
            selectedObject = ((GraphicalEditPart)selectedObject).resolveSemanticElement();
        }
        return selectedObject;
    }

    public GraphicalEditPart getSelectedGraphicalObject(ExecutionEvent event) {
        logger.debug((Object)("ExecutionEvent: " + event));
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        logger.debug((Object)("selection: " + selection));
        return this.getSelectedGraphicalObject(selection);
    }

    private GraphicalEditPart getSelectedGraphicalObject(Object selection) {
        logger.debug((Object)("selection: " + selection));
        Object selectedObject = selection;
        GraphicalEditPart editPart = (GraphicalEditPart)((IStructuredSelection)selectedObject).getFirstElement();
        return editPart;
    }

    public Class getUmlComponentFromSelectedObject(ExecutionEvent event) throws NoComponentException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        logger.debug((Object)("current selection: " + selection));
        Object selectedUmlElement = this.getUmlSelectedObject(selection);
        logger.debug((Object)("selectedUmlElement: " + selectedUmlElement));
        if (selectedUmlElement instanceof Property && this.entityUtil.isComponentInstance((Element)((Property)selectedUmlElement))) {
            selectedUmlElement = this.entityUtil.getUmlType((Property)selectedUmlElement);
        }
        if (selectedUmlElement instanceof Class) {
            if (selectedUmlElement instanceof StateMachine) {
                return (Class)((StateMachine)selectedUmlElement).getOwner();
            }
            if (!this.contractEntityUtil.isContract((Element)selectedUmlElement)) {
                return (Class)selectedUmlElement;
            }
        }
        throw new NoComponentException();
    }

    public Resource getSelectedModelResource() {
        UmlModel umlModel = this.getSelectedUmlModel();
        return this.getSelectedModelResource(umlModel);
    }

    public UmlModel getSelectedUmlModel() {
        return UmlUtils.getUmlModel();
    }

    public Resource getSelectedModelResource(UmlModel umlModel) {
        if (umlModel != null) {
            return umlModel.getResource();
        }
        return null;
    }
}

