/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.core.utils;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.uml2.uml.Class;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;

public class FileNamesUtil {
    private static final String XML_EXT = ".xml";
    public static final String UML_EXT = ".uml";
    public static final String OSS_EXT = ".oss";
    public static final String SMV_EXT = ".smv";
    public static final String FEI_EXT = ".fei";
    public static final String OCRA_FOLD = "NuSMV3-OCRA";
    public static final String XSAP_FOLD = "NuSMV3-XSAP";
    public static final String RES_FOLD = "Results";
    public static final String FILES_FOLD = "Files";
    public static final String TEMP_FOLD = "Temp";
    private static FileNamesUtil fileNamesUtil;
    private final AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();

    public static FileNamesUtil getInstance() {
        if (fileNamesUtil == null) {
            fileNamesUtil = new FileNamesUtil();
        }
        return fileNamesUtil;
    }

    public IFolder computeXSapFolder(IEditorPart editor) throws CoreException {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile inputfile = input.getFile();
        IProject project = inputfile.getProject();
        IFolder folder = this.getOrCreateFolder(project.getFolder(XSAP_FOLD));
        return folder;
    }

    private String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        return simpleDateFormat.format(new Date());
    }

    public String computeFtFileName(IEditorPart editor, String modelSystemName, int index) {
        String resPath = this.analysisResultUtil.getResultDir();
        String fileName = String.valueOf(resPath) + File.separator + "extended_" + modelSystemName + "_" + Analysis.FTA_ANALYSIS + "_c" + index + "_" + this.getDate() + XML_EXT;
        return fileName;
    }

    public String computeFmeaFileName(IEditorPart editor, String modelSystemName) {
        String resPath = this.analysisResultUtil.getResultDir();
        String fileName = String.valueOf(resPath) + File.separator + modelSystemName + "_" + Analysis.FMEA_ANALYSIS + "_" + this.getDate() + XML_EXT;
        return fileName;
    }

    public String computeExtendedSmvFileName(IEditorPart editor, String modelSystemName) throws CoreException {
        IFolder folder = this.computeXSapFolder(editor);
        IFolder tempFolder = this.getOrCreateFolder(folder.getFolder(TEMP_FOLD));
        String tempFiles = tempFolder.getLocation().toString();
        String fileName = String.valueOf(tempFiles) + "/" + "extended_" + modelSystemName + SMV_EXT;
        return fileName;
    }

    public String computeExpandedFeiFileName(IEditorPart editor, String modelSystemName) throws CoreException {
        IFolder folder = this.computeXSapFolder(editor);
        IFolder tempFolder = this.getOrCreateFolder(folder.getFolder(TEMP_FOLD));
        String tempFiles = tempFolder.getLocation().toString();
        String fileName = String.valueOf(tempFiles) + "/" + "expanded_" + modelSystemName + XML_EXT;
        return fileName;
    }

    public String computeFmsFileName(IEditorPart editor, String modelSystemName) throws CoreException {
        IFolder folder = this.computeXSapFolder(editor);
        IFolder tempFolder = this.getOrCreateFolder(folder.getFolder(TEMP_FOLD));
        String tempFiles = tempFolder.getLocation().toString();
        String fileName = String.valueOf(tempFiles) + "/" + "fms_" + modelSystemName + XML_EXT;
        return fileName;
    }

    public String computeFileTargetFolder(IEditorPart editor) throws CoreException {
        IFolder folder = this.computeXSapFolder(editor);
        IFolder files = this.getOrCreateFolder(folder.getFolder(FILES_FOLD));
        File target = files.getLocation().toFile();
        return target.toString();
    }

    public String computeSmvFileName(IEditorPart editor, String modelSystemName) throws CoreException {
        return String.valueOf(this.computeFileTargetFolder(editor)) + "/" + modelSystemName + SMV_EXT;
    }

    public String computeFeiFileName(IEditorPart editor, String modelSystemName) throws CoreException {
        return String.valueOf(this.computeFileTargetFolder(editor)) + "/" + modelSystemName + FEI_EXT;
    }

    private String computeQualifiedName(Class component) {
        String name = component.getQualifiedName();
        return name.replace("::", "_");
    }

    public String computeContractFaultTreeFileName(Class systemComponent) {
        String resPath = this.analysisResultUtil.getResultDir();
        return String.valueOf(resPath) + File.separator + this.computeQualifiedName(systemComponent) + "_" + Analysis.CONTRACT_BASED_FTA_ANALYSIS + "_" + this.getDate() + XML_EXT;
    }

    public String computeContractRefinementFileName(Class systemComponent) {
        String resPath = this.analysisResultUtil.getResultDir();
        return String.valueOf(resPath) + File.separator + this.computeQualifiedName(systemComponent) + "_" + Analysis.CONTRACT_REFINEMENT_ANALYSIS + "_" + this.getDate() + XML_EXT;
    }

    public String computeContractCompositeImplementationFileName(Class systemComponent) {
        String resPath = this.analysisResultUtil.getResultDir();
        return String.valueOf(resPath) + File.separator + this.computeQualifiedName(systemComponent) + "_" + Analysis.CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS + "_" + this.getDate() + XML_EXT;
    }

    public String computePropertyValidationFileName(Class systemComponent) {
        String resPath = this.analysisResultUtil.getResultDir();
        return String.valueOf(resPath) + File.separator + this.computeQualifiedName(systemComponent) + "_" + Analysis.PROPERTY_VALIDATION_ANALYSIS + "_" + this.getDate() + XML_EXT;
    }

    public String computeContractPropertyValidationFileName(Class systemComponent) {
        String resPath = this.analysisResultUtil.getResultDir();
        return String.valueOf(resPath) + File.separator + this.computeQualifiedName(systemComponent) + "_" + Analysis.CONTRACT_PROPERTY_VALIDATION_ANALYSIS + "_" + this.getDate() + XML_EXT;
    }

    public String computeModelCheckingFileName(Class systemComponent) {
        String resPath = this.analysisResultUtil.getResultDir();
        return String.valueOf(resPath) + File.separator + this.computeQualifiedName(systemComponent) + "_" + Analysis.MODEL_CHECKING_ANALYSIS + "_" + this.getDate() + XML_EXT;
    }

    private IFolder getOrCreateFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }
}

