\documentclass[11pt]{article}
\usepackage{graphicx}
\usepackage{array}
\usepackage[T1]{fontenc}
\usepackage{longtable}
\usepackage{fullpage}
\catcode`\_=12
\usepackage{float}
\usepackage{listings}
\usepackage{color}
\usepackage{xcolor}
\usepackage{hyperref}
\usepackage{adjustbox}
\renewcommand{\ttdefault}{pcr}
\definecolor{myRed}{HTML}{8F0000}
\definecolor{myGreen}{HTML}{00F000}
\definecolor{myYellow}{HTML}{F1AF00}
\lstdefinestyle{ocra}{
escapechar={@},
language=C,
breaklines=true,
basicstyle=\scriptsize \ttfamily,
captionpos=t,
frame=single,
morekeywords=[2]{count, der, min, max, abs, next, fall, rise, change, time_since, time_until, 
always, G, never, in, the, future, past, F, then, X, O, historically, H, previously, Y, until, 
U, releases, V, since, S, triggered, T, at, next, last, iff, implies, and, or, xor, xnor, true, 
false, TRUE, FALSE, not, mod, CONTRACT, assume, guarantee, ASSERTION, NAME, PARAMETER, 
ASSUMPTIONS, DEFINE, big_or, big_and, refined, by},
comment=[l]{--},
morecomment=[s]{/--}{--/},
identifierstyle=\ttfamily,
keywordstyle=\color{black} \ttfamily,
keywordstyle=[2]\color{myRed} \bfseries \ttfamily,
commentstyle=\color{gray} \ttfamily,
stringstyle=\color{gray} \ttfamily
}
\lstdefinestyle{check}{
escapechar={@},
language=C,
breaklines=true,
basicstyle=\ttfamily,
captionpos=t,
frame=single,
morekeywords=[2]{Success},
morekeywords=[3]{NOT, OK},
morekeywords=[4]{Unknown},
comment=[l]{--},
morecomment=[s]{/--}{--/},
identifierstyle=\ttfamily,
keywordstyle=\color{black} \ttfamily,
keywordstyle=[2]\color{myGreen} \bfseries \ttfamily,
keywordstyle=[3]\color{myRed} \bfseries \ttfamily,
keywordstyle=[4]\color{myYellow} \bfseries \ttfamily,
commentstyle=\color{gray} \ttfamily,
stringstyle=\color{gray} \ttfamily
}

\hypersetup{
    colorlinks,
    linkcolor=blue
}
\setlength{\parindent}{0cm}

\begin{document}
\title{Project: ${title}}
\maketitle
\newpage
\setcounter{tocdepth}{2}
\tableofcontents
\newpage

<#list containers as container>

<#if container.component??>
%\clearpage
\subsection{${container.name}}
\label{sec:${title}.${container.name}}
<#else>
\section{${container.name}}
</#if>
<#list container.diagrams as diagram>
\begin{center}
\maxsizebox{\textwidth}{0.95\textheight}{
\includegraphics{"${diagram.url_no_extension}"}}
\end{center}
</#list>
<#if container.component??>
\subsubsection{Component description}
%Name: ${container.name}\\
<#if container.component.type?length != 0>
{\bfseries Type:} ${container.component.type}\\
<#else>
\\
</#if>
{\bfseries Notes:} 
<#if container.component.refinementType?length != 0> ${container.component.refinementType} refinement\\
</#if>


<#if container.component.parameters?size != 0>
\begin{longtable}[l]{ |m{20em}|m{21em}| }
\caption{${container.name} parameters}\\
\hline
{\bfseries Name} & {\bfseries Type} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Name} & {\bfseries Type} \\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.parameters as parameter>
{\small ${parameter.name}} & {\small ${parameter.type}} \\
</#list>
\hline
\end{longtable}
</#if>


<#if container.component.localAttributes?size != 0>
\begin{longtable}[l]{ |m{20em}|m{21em}| }
\caption{${container.name} local attributes}\\
\hline
{\bfseries Name} & {\bfseries Type}\\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Name} & {\bfseries Type}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.localAttributes as localAttribute>
{\small ${localAttribute.name}} & 
<#if localAttribute.type??>
{\small ${localAttribute.type}} \\
<#else>
{\small null} \\
</#if>
</#list>
\hline
\end{longtable}
</#if>


<#if container.component.uninterpretedFunctions?size != 0>
\begin{longtable}[l]{ |m{16em}|m{8em}|m{16em}| }
\caption{${container.name} uninterpreted functions}\\
\hline
{\bfseries Name} & {\bfseries Output Type} & {\bfseries Input Types} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Name} & {\bfseries Output Type} & {\bfseries Input Types}\\
\hline
\endhead
\hline 
\multicolumn{3}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.uninterpretedFunctions as uninterpretedFunction>
{\small ${uninterpretedFunction.name}} & {\small ${uninterpretedFunction.type}} &
<#if uninterpretedFunction.input?length != 0>
{\small ${uninterpretedFunction.input}}
</#if> \\
\hline
</#list>
\end{longtable}
</#if>


<#if container.component.inputPorts?size != 0>
\begin{longtable}[l]{ |m{20em}|m{21em}| }
\caption{${container.name} input ports}\\
\hline
{\bfseries Name} & {\bfseries Type}\\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Name} & {\bfseries Type}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.inputPorts as inputPort>
{\small ${inputPort.name}} & {\small ${inputPort.type}} \\
</#list>
\hline
\end{longtable}
</#if>


<#if container.component.outputPorts?size != 0>
\begin{longtable}[l]{ |m{20em}|m{21em}| }
\caption{${container.name} output ports}\\
\hline
{\bfseries Name} & {\bfseries Type} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Name} & {\bfseries Type}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.outputPorts as outputPort>
{\small ${outputPort.name}} & {\small ${outputPort.type}} \\
</#list>
\hline
\end{longtable}
</#if>


<#if container.component.subComponents?size != 0>
\begin{longtable}[l]{ |m{20em}|m{21em}| }
\caption{${container.name} sub components}\\
\hline
{\bfseries Name} & {\bfseries Type} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Name} & {\bfseries Type}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.subComponents as subComponent>
{\small ${subComponent.name}} & \hyperref[sec:${title}.${subComponent.type}]{{\small ${subComponent.type}}}
<#if (subComponent.multiplicity?has_content)>
{\small ${subComponent.multiplicity}}
</#if> \\
</#list>
\hline
\end{longtable}
</#if>


<#if container.component.connections?size != 0>
% The following table can have two or three columns, depending on the 
% prensence of an Iterative Condition in the connections
<#if container.component.connectionDescriptorIterativeCond??>
\begin{longtable}[l]{ |m{16em}|m{16em}|m{8em}| }
\caption{${container.name} connections}\\
\hline
{\bfseries Connected Port} & {\bfseries Connecting Port} & {\bfseries Iterative Cond.} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Connected Port} & {\bfseries Connecting Port}  & {\bfseries Iterative Cond.} \\
\hline
\endhead
\hline 
\multicolumn{3}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.connections as connection>
{\small ${connection.port1}} & {\small ${connection.port2}} &
<#if (connection.iterativeCondition?has_content)>
{\small ${connection.iterativeCondition}}
</#if> \\
</#list>
\hline
\end{longtable}
<#else>
\begin{longtable}[l]{ |m{20em}|m{21em}| }
\caption{${container.name} connections}\\
\hline
{\bfseries Connected Port} & {\bfseries Connecting Port} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Connected Port} & {\bfseries Connecting Port} \\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list container.component.connections as connection>
{\small ${connection.port1}} & {\small ${connection.port2}} \\
</#list>
\hline
\end{longtable}
</#if>
</#if>


<#if (container.component.defines?size != 0)>
\begin{lstlisting}[style=ocra, caption= ${container.name} defines]
<#list container.component.defines as define>
DEFINE ${define.name} := ${define.text} ;

</#list>
\end{lstlisting}
</#if>


<#if (container.component.parameterAssumptions?size != 0)>
\begin{lstlisting}[style=ocra, caption= ${container.name} parameter assumptions]
<#list container.component.parameterAssumptions as parameterAssumptions>
PARAMETER ASSUMPTIONS ${parameterAssumptions.text} ;

</#list>
\end{lstlisting}
</#if>


<#if (container.component.interfaceAssertions?size != 0)>
\begin{lstlisting}[style=ocra, caption= ${container.name} interface assertions]
<#list container.component.interfaceAssertions as assertion>
@\label{assert:${title}.${container.name}.${assertion.name}}@ASSERTION NAME ${assertion.name} := ${assertion.text}

</#list>
\end{lstlisting}
</#if>


<#if (container.component.refinementAssertions?size != 0)>
\begin{lstlisting}[style=ocra, caption= ${container.name} refinement assertions]
<#list container.component.refinementAssertions as assertion>
ASSERTION NAME ${assertion.name} := ${assertion.text}

</#list>
\end{lstlisting}
</#if>


<#if container.component.contracts?size != 0>
\begin{lstlisting}[style=ocra, caption= ${container.name} contracts]
<#list container.component.contracts as contract>
CONTRACT ${contract.name}
assume: <#if (contract.assumptionLink?has_content)>@\hyperref[assert:${title}.${contract.assumptionLink}]{${contract.assumption}}@
<#else>
${contract.assumption}
</#if>
guarantee: <#if (contract.guaranteeLink?has_content)>@\hyperref[assert:${title}.${contract.guaranteeLink}]{${contract.guarantee}}@
<#else>
${contract.guarantee}
</#if>

</#list>
\end{lstlisting}
</#if>


<#if container.component.contractRefinements?size != 0>
\begin{lstlisting}[style=ocra, caption= ${container.name} contract refinements]
<#list container.component.contractRefinements as contractRefinement>
CONTRACT ${contractRefinement.refinedContractName}
refined by: 
${contractRefinement.refiningContractsNames}

</#list>
\end{lstlisting}
</#if>
</#if>
</#list>


% Results section
<#list descriptors as descriptor>
<#if descriptor.showAnalysisResults??>
\section{Validation and Verification Results}
\subsection{Properties Validation Results:}
<#if (descriptor.propertyValidationResults?size != 0)>
<#list descriptor.propertyValidationResults as propertyValidationResult>
{\bfseries Main class:} ${propertyValidationResult.rootClass}\\
{\bfseries Type of validation:} ${propertyValidationResult.validationType}\\
<#if (propertyValidationResult.selectedComponent??)>
{\bfseries Selected component:} ${propertyValidationResult.selectedComponent}\\
</#if>
<#if (propertyValidationResult.selectedProperties??)>
{\bfseries Selected properties:} ${propertyValidationResult.selectedProperties}\\
</#if>
<#if (propertyValidationResult.conditions??)>
{\bfseries Conditions:} ${propertyValidationResult.conditions}\\
</#if>
\vspace{-5mm}
\begin{longtable}[l]{ |m{30em}|m{11em}| }
\hline
{\bfseries Property} & {\bfseries Status} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Property} & {\bfseries Status}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list propertyValidationResult.validationLines as line>
{\small ${line.property}} & {\small \lstinline[style=check]!${line.status}!} \\
</#list>
\hline
\end{longtable}
\bigskip
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Assume/Guarantee Properties Validation Results:}
<#if (descriptor.contractPropertyValidationResults?size != 0)>
<#list descriptor.contractPropertyValidationResults as contractPropertyValidationResult>
{\bfseries Main class:} ${contractPropertyValidationResult.rootClass}\\
{\bfseries Type of validation:} ${contractPropertyValidationResult.validationType}\\
<#if (contractPropertyValidationResult.selectedComponent??)>
{\bfseries Selected component:} ${contractPropertyValidationResult.selectedComponent}\\
</#if>
<#if (contractPropertyValidationResult.selectedProperties??)>
{\bfseries Selected properties:} ${contractPropertyValidationResult.selectedProperties}\\
</#if>
<#if (contractPropertyValidationResult.conditions??)>
{\bfseries Conditions:} ${contractPropertyValidationResult.conditions}\\
</#if>
\vspace{-5mm}
\begin{longtable}[l]{ |m{30em}|m{11em}| }
\hline
{\bfseries Property} & {\bfseries Status} \\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Property} & {\bfseries Status}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list contractPropertyValidationResult.validationLines as line>
{\small ${line.property}} & {\small \lstinline[style=check]!${line.status}!} \\
</#list>
\hline
\end{longtable}
\bigskip
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Contract Refinement Results:}
<#if (descriptor.contractRefinementResults?size != 0)>
<#list descriptor.contractRefinementResults as contractRefinementResult>
{\bfseries Main class:} ${contractRefinementResult.rootClass}\\
\vspace{-5mm}
\begin{longtable}[l]{ |m{30em}|m{11em}| }
\hline
{\bfseries Contract} & {\bfseries Status}\\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Contract} & {\bfseries Status}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list contractRefinementResult.refinementLines as line>
{\small ${line.contract}} & {\small \lstinline[style=check]!${line.status}!}\\
</#list>
\hline
\end{longtable}
\bigskip
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Check Contract Composite Implementation Results:}
<#if (descriptor.contractImplementationResults?size != 0)>
<#list descriptor.contractImplementationResults as contractImplementationResult>
{\bfseries Main class:} ${contractImplementationResult.rootClass}\\
\vspace{-5mm}
\begin{longtable}[l]{ |m{30em}|m{11em}| }
\hline
{\bfseries Contract} & {\bfseries Status}\\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Contract} & {\bfseries Status}\\
\hline
\endhead
\hline 
\multicolumn{2}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list contractImplementationResult.implementationLines as line>
{\small ${line.contract}} & {\small \lstinline[style=check]!${line.status}!}\\
</#list>
\hline
\end{longtable}
\bigskip
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Contract-based Fault Tree Analysis Results:}
<#if (descriptor.contractFtaResults?size != 0)>
<#list descriptor.contractFtaResults as contractFtaResult>
{\bfseries Main class:} ${contractFtaResult.rootClass}\\
\begin{center}
\maxsizebox{\textwidth}{0.95\textheight}{
\includegraphics{"${contractFtaResult.url_no_extension}"}}
\end{center}
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Model Checking  Results:}
<#if (descriptor.modelCheckingResults?size != 0)>
<#list descriptor.modelCheckingResults as modelCheckingResult>
{\bfseries Main class:} ${modelCheckingResult.rootClass}\\
{\bfseries Type of check:} ${modelCheckingResult.checkType}\\
{\bfseries Conditions:} ${modelCheckingResult.conditions}\\
{\bfseries Model status:} \lstinline[style=check]!${modelCheckingResult.result}!\\
\\
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Fault Tree Analysis Results:}
<#if (descriptor.ftaResults?size != 0)>
<#list descriptor.ftaResults as ftaResult>
{\bfseries Main class:} ${ftaResult.rootClass}\\
{\bfseries Conditions:} ${ftaResult.conditions}\\
\begin{center}
\maxsizebox{\textwidth}{0.95\textheight}{
\includegraphics{"${ftaResult.url_no_extension}"}}
\end{center}
\bigskip
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
\subsection{Failure Modes and Effects Analysis Results:}
<#if (descriptor.fmeaResults?size != 0)>
<#list descriptor.fmeaResults as fmeaResult>
{\bfseries Main class:} ${fmeaResult.rootClass}\\
{\bfseries Conditions:} ${fmeaResult.conditions}\\
\begin{longtable}[l]{ |m{5em}|m{27em}|m{8em}| }
\hline
{\bfseries Entry ID} & {\bfseries Failure Mode} & {\bfseries Failure Effects}\\
\hline
\endfirsthead
\caption[]{\textit{Continued from previous page}}\\
\hline
{\bfseries Entry ID} & {\bfseries Failure Mode} & {\bfseries Failure Effects}\\
\hline
\endhead
\hline 
\multicolumn{3}{r}%
{\textit{Continued on next page}}\\
\endfoot
\endlastfoot
<#list fmeaResult.fmeaLines as line>
{\small ${line.entry}} & {\small ${line.failureMode}} & {\small ${line.failureEffects}} \\
</#list>
\hline
\end{longtable}
\bigskip
</#list>
<#else>
{\itshape Results not available.}\\
</#if>
</#if>
</#list>
\end{document}
