/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.faultTreeViewer.emfta;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventType implements Enumerator
{
    BASIC(0, "Basic", "Basic"),
    EXTERNAL(1, "External", "External"),
    UNDEVELOPPED(2, "Undevelopped", "Undevelopped"),
    CONDITIONING(3, "Conditioning", "Conditioning"),
    INTERMEDIATE(4, "Intermediate", "Intermediate");

    public static final int BASIC_VALUE = 0;
    public static final int EXTERNAL_VALUE = 1;
    public static final int UNDEVELOPPED_VALUE = 2;
    public static final int CONDITIONING_VALUE = 3;
    public static final int INTERMEDIATE_VALUE = 4;
    private static final EventType[] VALUES_ARRAY;
    public static final List<EventType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventType[]{BASIC, EXTERNAL, UNDEVELOPPED, CONDITIONING, INTERMEDIATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventType get(int value) {
        switch (value) {
            case 0: {
                return BASIC;
            }
            case 1: {
                return EXTERNAL;
            }
            case 2: {
                return UNDEVELOPPED;
            }
            case 3: {
                return CONDITIONING;
            }
            case 4: {
                return INTERMEDIATE;
            }
        }
        return null;
    }

    private EventType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

