/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.ui.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.marte.vsl.ui.contentassist.Tree;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureTree
extends Tree<Feature> {
    private List<Classifier> typesCrossedToReachThisTree = new ArrayList<Classifier>();

    public FeatureTree(Feature root) {
        super(root);
    }

    public FeatureTree(Feature root, List<Classifier> typesCrossedToReachThisTree) {
        this(root);
        this.typesCrossedToReachThisTree.addAll(typesCrossedToReachThisTree);
        this.buildTree();
    }

    @Override
    public void buildTree() {
        Classifier featureType = null;
        if (this.root instanceof Property) {
            featureType = (Classifier)((Property)this.root).getType();
        } else if (this.root instanceof Operation) {
            featureType = (Classifier)((Operation)this.root).getType();
        }
        if (featureType == null) {
            return;
        }
        if (this.typesCrossedToReachThisTree.contains(featureType)) {
            return;
        }
        this.typesCrossedToReachThisTree.add(featureType);
        for (Feature property : featureType.getAllAttributes()) {
            this.getChildren().add(new FeatureTree(property, this.typesCrossedToReachThisTree));
        }
        for (Feature operation : featureType.getAllOperations()) {
            this.getChildren().add(new FeatureTree(operation, this.typesCrossedToReachThisTree));
        }
    }

    public static List<FeatureTree> buildListOfFeatureTrees(Classifier classifier) {
        ArrayList<FeatureTree> list = new ArrayList<FeatureTree>();
        ArrayList<Classifier> typesCrossedToReachThisTree = new ArrayList<Classifier>();
        typesCrossedToReachThisTree.add(classifier);
        for (Feature property : classifier.getAllAttributes()) {
            list.add(new FeatureTree(property, typesCrossedToReachThisTree));
        }
        for (Feature operation : classifier.getAllOperations()) {
            list.add(new FeatureTree(operation, typesCrossedToReachThisTree));
        }
        return list;
    }

    public static boolean canClassifierBeReached(List<FeatureTree> listOfFeatureTrees, Classifier classifier) {
        boolean classifierReached = false;
        Iterator<FeatureTree> i = listOfFeatureTrees.iterator();
        while (i.hasNext() && !classifierReached) {
            classifierReached = i.next().canClassifierBeReached(classifier);
        }
        return classifierReached;
    }

    public boolean canClassifierBeReached(Classifier classifier) {
        for (Classifier type : this.typesCrossedToReachThisTree) {
            if (classifier == type || type.conformsTo((Type)classifier)) {
                return true;
            }
            if (!type.getName().equals(classifier.getName()) || !type.getName().equals("Integer") && !type.getName().equals("Integer") && !type.getName().equals("String")) continue;
            return true;
        }
        boolean classifierReached = false;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext() && !classifierReached) {
            classifierReached = ((FeatureTree)i.next()).canClassifierBeReached(classifier);
        }
        return classifierReached;
    }
}

