/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.tree;

import eu.fbk.tools.adapter.ui.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TreeObject
implements IAdaptable {
    private String id;
    private final String code;
    private final String label;
    private TreeObject parent = null;
    private Object contentProvider = null;
    private String icon;
    private String tooltip = "";
    private final List<TreeObject> children = new ArrayList<TreeObject>();

    public TreeObject(String code, String label) {
        this.id = code;
        this.code = code;
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setParent(TreeObject parent) {
        this.parent = parent;
        if (parent != null) {
            this.id = String.valueOf(parent.getId()) + "." + this.code;
        }
    }

    public TreeObject getParent() {
        return this.parent;
    }

    public void clear() {
        for (TreeObject child : this.children) {
            child.clear();
        }
        this.children.clear();
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String toString() {
        return this.getLabel();
    }

    public Object getAdapter(Class key) {
        return null;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public Image getImage() {
        if (this.icon == null) {
            if (this.children.isEmpty()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor(this.icon);
        if (imageDescriptor == null) {
            if (this.children.isEmpty()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return imageDescriptor.createImage();
    }

    public Object getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(Object contentProvider) {
        this.contentProvider = contentProvider;
    }
}

