/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.trace.contract.property;

import eu.fbk.tools.adapter.results.Assignment;
import eu.fbk.tools.adapter.results.Section;
import eu.fbk.tools.adapter.results.State;
import eu.fbk.tools.adapter.results.Trace;
import eu.fbk.tools.adapter.ui.views.trace.BaseTraceViewer;
import eu.fbk.tools.adapter.ui.views.trace.contract.property.PropertyTraceTreeViewContentProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Display;

public class ValidationPropertyTraceViewer
extends BaseTraceViewer {
    public static final String ID = "eu.fbk.tools.adapter.ui.views.trace.contract.property.ValidationPropertyTraceViewer";

    public ValidationPropertyTraceViewer() {
        super(new PropertyTraceTreeViewContentProvider());
    }

    @Override
    protected void createColumns(Trace trace) {
        if (trace.getStates().isEmpty()) {
            return;
        }
        GridColumn columnPorts = new GridColumn(this.tableViewer, 0);
        columnPorts.setText("Ports");
        columnPorts.setWidth(200);
        columnPorts.setAlignment(16384);
        columnPorts.setTree(true);
        Hashtable<String, List> ports = new Hashtable<String, List>();
        for (State state : trace.getStates()) {
            GridColumnGroup columnGroup = new GridColumnGroup(this.tableViewer, 0);
            columnGroup.setText("Step " + state.getId());
            for (Section section : state.getSections()) {
                GridColumn column = new GridColumn(columnGroup, 0);
                column.setAlignment(16384);
                column.setText(section.getName());
                column.setWidth(90);
                for (Assignment assignement : section.getAssignments()) {
                    if (!ports.containsKey(assignement.getVariable())) {
                        ports.put(assignement.getVariable(), new ArrayList());
                    }
                    List dataPortValues = (List)ports.get(assignement.getVariable());
                    dataPortValues.add(assignement.getValue());
                }
            }
        }
        ports.forEach((K, V) -> {
            if (this.showAllAssignments || !this.areAllValuesIdentical((List<String>)V)) {
                this.populatePortName((String)K);
            }
        });
        int stateValueItemIndex = 1;
        int step = ports.size() > 0 ? 1 : 0;
        for (State state : trace.getStates()) {
            for (Section section : state.getSections()) {
                for (Assignment assignement : section.getAssignments()) {
                    String valueToCheck;
                    GridItem item = (GridItem)this.gridItems.get(assignement.getVariable());
                    if (item == null) continue;
                    item.setText(stateValueItemIndex, assignement.getValue());
                    if (stateValueItemIndex > step && !item.getText(stateValueItemIndex - step).equals(assignement.getValue())) {
                        item.setToolTipText(0, "The port value changes along the trace");
                        item.setForeground(0, Display.getCurrent().getSystemColor(4));
                        item.setForeground(stateValueItemIndex, Display.getCurrent().getSystemColor(1));
                        item.setBackground(stateValueItemIndex, Display.getCurrent().getSystemColor(4));
                    }
                    if (!(valueToCheck = assignement.getValue().trim().toLowerCase()).equals("true") && !valueToCheck.equals("false")) continue;
                    item.setToolTipText(0, "This is a boolean port");
                    item.setForeground(0, Display.getCurrent().getSystemColor(9));
                }
                stateValueItemIndex += step;
            }
        }
    }
}

