/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result.safety;

import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.views.fmeatable.FmeaTableView;
import eu.fbk.tools.adapter.xsap.ComputeFmeaTableResultBuilder;
import eu.fbk.tools.adapter.xsap.table.FmeaTable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeFmeaTableResultProcessor
extends ResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ComputeFmeaTableResultProcessor.class);
    private FmeaTable fmeaTable;

    public ComputeFmeaTableResultProcessor(String functionName) {
        super(functionName);
    }

    @Override
    public boolean processResult() {
        if (!this.resultFileExists()) {
            return false;
        }
        ComputeFmeaTableResultBuilder resultBuilder = new ComputeFmeaTableResultBuilder();
        this.fmeaTable = resultBuilder.unmarshalResult(this.resultFile);
        if (this.fmeaTable == null || this.fmeaTable.getRow() == null || this.fmeaTable.getRow().isEmpty()) {
            this.displayError(this.functionName, "Internal error while umarshalling the result. For more info see the console");
            return false;
        }
        return true;
    }

    @Override
    public void displayResult() {
        if (this.fmeaTable == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            try {
                FmeaTableView viewPart = (FmeaTableView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.fbk.tools.adapter.ui.views.fmeatable.FmeaTableView", null, 2);
                if (viewPart != null) {
                    TableViewer tableViewer = viewPart.getViewer();
                    IContentProvider provider = tableViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    tableViewer.setInput((Object)this.fmeaTable.getRow());
                    tableViewer.refresh();
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)viewPart);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
    }
}

