/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result.safety;

import eu.fbk.tools.adapter.nusmv.CounterExample;
import eu.fbk.tools.adapter.nuxmv.CheckBehaviourResultBuilder;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.views.trace.TraceViewPart;
import eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CheckDiagnosabilityResultProcessor
extends ResultProcessor {
    private ModelCheckResult checkDiagnosabilityResult;
    private boolean textMessage;

    public CheckDiagnosabilityResultProcessor(String functionName) {
        super(functionName);
    }

    @Override
    public boolean processResult() {
        this.checkDiagnosabilityResult = null;
        List<AlarmResult> results = this.generateAlarms(this.resultFile);
        this.populateAlarms(this.resultFile, results);
        File editedOutput = new File(this.resultFile.getParentFile(), "result.txt");
        this.setResultFile(editedOutput);
        if (editedOutput.exists()) {
            this.setResultFile(editedOutput);
            this.textMessage = true;
            return true;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(editedOutput));
            for (AlarmResult alarmResult : results) {
                writer.write("Specification " + alarmResult.getIndex());
                writer.newLine();
                writer.write("--------------------------------------------------------------------------------");
                writer.newLine();
                switch (alarmResult.getResult()) {
                    case False: {
                        writer.write("Result: The specification is not diagnosable in the system. A pair of traces has ");
                        writer.newLine();
                        writer.write("been generated that show non-diagnosability:");
                        writer.newLine();
                        String traceIndex = String.valueOf(alarmResult.getTraceIndex()) + "_";
                        File traceFile = new File(this.resultFile.getParentFile(), String.valueOf(traceIndex) + "trace.xml");
                        this.splitTraces(traceFile, traceIndex);
                        writer.write("Trace A: " + this.getTraceAName(traceIndex));
                        writer.newLine();
                        writer.write("Trace B: " + this.getTraceBName(traceIndex));
                        writer.newLine();
                        break;
                    }
                    case True: {
                        writer.write("Result: The specification is diagnosable in the system.");
                        writer.newLine();
                        break;
                    }
                    case Unknown: {
                        writer.write("Result: No counterexample found within analysis bound.");
                        writer.newLine();
                        break;
                    }
                    case Unknown_inc: {
                        writer.write("Result: No counterexample found, must use different algorithm.");
                        writer.newLine();
                    }
                }
                writer.write("--------------------------------------------------------------------------------");
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        if (this.resultFile.getName().equals("result.txt")) {
            this.textMessage = true;
            return true;
        }
        File testFile = new File("C:\\Work\\Boeing\\eclipse-manual\\runtime-EclipseXtext\\Temp\\xSAP_865272b74ed66ad\\trace1_A.xml");
        CheckBehaviourResultBuilder resultBuilder = new CheckBehaviourResultBuilder();
        if (this.resultFileExists()) {
            CounterExample counterExample = resultBuilder.unmarshalResult(testFile);
            if (counterExample == null || counterExample.getDesc() == null || counterExample.getId() == null || counterExample.getNode() == null) {
                this.displayError(this.functionName, "Internal error while processing the result. For more info see the console");
                return false;
            }
            this.checkDiagnosabilityResult = resultBuilder.buildResult(this.functionName, "", counterExample);
        } else {
            this.checkDiagnosabilityResult = resultBuilder.buildResult(this.functionName, "");
        }
        if (this.checkDiagnosabilityResult == null) {
            this.displayError(this.functionName, "Internal error while processing the result. For more info see the console");
            return false;
        }
        return true;
    }

    private List<AlarmResult> generateAlarms(File resultFile) {
        ArrayList<AlarmResult> results = new ArrayList<AlarmResult>();
        Pattern typePattern = Pattern.compile("^Generated (\\w+)* proof obligation.$");
        try {
            Scanner scanner = new Scanner(resultFile);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Matcher matcher = typePattern.matcher(line);
                if (!matcher.matches()) continue;
                String patternType = matcher.group(1);
                AlarmResult result = new AlarmResult(patternType, results.size());
                results.add(result);
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return results;
    }

    private void populateAlarms(File resultFile, List<AlarmResult> results) {
        Pattern holdsPattern = Pattern.compile("^-- (?:LTL )?specification (?:.*) is (true|false)$");
        Pattern terminatingPattern = Pattern.compile("^-- terminating with bound (\\d+).$");
        Pattern boundPattern = Pattern.compile("^-- no counterexample found with bound (\\d+)$");
        int alarmCounter = 0;
        int falseCounter = 1;
        try {
            Scanner scanner = new Scanner(resultFile);
            String previousLine = null;
            String line = null;
            while (scanner.hasNextLine()) {
                int lastBound;
                previousLine = line;
                line = scanner.nextLine();
                Matcher matcher = holdsPattern.matcher(line);
                if (matcher.matches()) {
                    String holds = matcher.group(1);
                    AlarmResult result = results.get(alarmCounter);
                    if (Boolean.valueOf(holds).booleanValue()) {
                        if (result.isIncomplete()) {
                            result.setResult(ResultType.Unknown_inc);
                        } else {
                            result.setResult(ResultType.True);
                        }
                    } else {
                        result.setResult(ResultType.False);
                        result.setTraceIndex(falseCounter++);
                    }
                    ++alarmCounter;
                }
                if (!(matcher = terminatingPattern.matcher(line)).matches()) continue;
                int terminatingStep = Integer.parseInt(matcher.group(1));
                matcher = boundPattern.matcher(previousLine);
                if (!matcher.matches() || (lastBound = Integer.parseInt(matcher.group(1))) != terminatingStep) continue;
                AlarmResult result = results.get(alarmCounter);
                result.setResult(ResultType.Unknown);
                ++alarmCounter;
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void splitTraces(File resultFile, String traceIndex) {
        if (this.resultFileExists()) {
            File traceL = new File(resultFile.getParentFile(), this.getTraceAName(traceIndex));
            File traceR = new File(resultFile.getParentFile(), this.getTraceBName(traceIndex));
            System.out.println("Trace a = " + traceL.getAbsolutePath());
            BufferedWriter writerL = null;
            BufferedWriter writerR = null;
            try {
                writerL = new BufferedWriter(new FileWriter(traceL));
                writerR = new BufferedWriter(new FileWriter(traceR));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
            try {
                Scanner scanner = new Scanner(resultFile);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.contains("twin_L.")) {
                        line = line.replace("twin_L.", "");
                        writerL.write(String.valueOf(line) + System.lineSeparator());
                        continue;
                    }
                    if (line.contains("twin_R.")) {
                        line = line.replace("twin_R.", "");
                        writerR.write(String.valueOf(line) + System.lineSeparator());
                        continue;
                    }
                    if (line.contains("<value variable")) continue;
                    writerL.write(String.valueOf(line) + System.lineSeparator());
                    writerR.write(String.valueOf(line) + System.lineSeparator());
                }
                scanner.close();
                writerL.close();
                writerR.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getTraceAName(String traceIndex) {
        return "trace" + traceIndex + "A.xml";
    }

    private String getTraceBName(String traceIndex) {
        return "trace" + traceIndex + "B.xml";
    }

    @Override
    public void displayResult() {
        if (this.textMessage) {
            super.displayResult();
            return;
        }
        if (this.checkDiagnosabilityResult == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            try {
                BehaviourTraceViewer traceViewPart = (BehaviourTraceViewer)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer", null, 2);
                if (traceViewPart != null) {
                    TreeViewer treeViewer = ((TraceViewPart)traceViewPart).getTreeViewer();
                    IContentProvider provider = treeViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)traceViewPart);
                    provider.inputChanged((Viewer)treeViewer, null, (Object)this.checkDiagnosabilityResult);
                    ((TraceViewPart)traceViewPart).refresh();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    class AlarmResult {
        private int index;
        private ResultType result;
        private String patternType;
        private int traceIndex;
        private final List<String> incompletePatterns = Arrays.asList("bounded", "BoundDel", "finite", "FiniteDel");

        public AlarmResult(String patternType, int index) {
            this.patternType = patternType;
            this.setIndex(index);
        }

        public ResultType getResult() {
            return this.result;
        }

        public void setResult(ResultType result) {
            this.result = result;
        }

        public boolean isIncomplete() {
            return this.incompletePatterns.contains(this.patternType);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getTraceIndex() {
            return this.traceIndex;
        }

        public void setTraceIndex(int traceIndex) {
            this.traceIndex = traceIndex;
        }
    }

    static enum ResultType {
        Unknown,
        Unknown_inc,
        True,
        False;

    }
}

