/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.progress;

import eu.fbk.tools.Request;
import eu.fbk.tools.RequestProvider;
import eu.fbk.tools.adapter.ToolRunner;
import eu.fbk.tools.adapter.oslc.OslcToolConsumer;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.result.ResultProcessorFactory;
import eu.fbk.tools.adapter.ui.views.request.RequestView;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(ToolJob.class);
    private final Request request;
    private final ToolRunner runner;
    private boolean headlessMode = false;

    public ToolJob(String name, ToolRunner runner) {
        super(name);
        this.runner = runner;
        this.request = runner instanceof OslcToolConsumer ? new Request(UUID.randomUUID().toString(), Request.RequestDestination.remote) : new Request(UUID.randomUUID().toString());
    }

    public ToolRunner getRunner() {
        return this.runner;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isHeadlessMode() {
        return this.headlessMode;
    }

    public void setHeadlessMode(boolean headlessMode) {
        this.headlessMode = headlessMode;
    }

    /*
     * Unable to fully structure code
     */
    protected IStatus run(IProgressMonitor monitor) {
        block25: {
            if (this.runner == null) {
                this.jobFail("Unexpected condition: the runner is null");
                return Status.CANCEL_STATUS;
            }
            logLevel = Activator.getDefault().getPreferenceStore().getString("debug.logLevel");
            if (logLevel.equals("DEBUG")) {
                this.runner.setDebugMode(true);
            } else {
                this.runner.setDebugMode(false);
            }
            function = this.runner.getToolFunction();
            this.request.setFunctionName(function.getName());
            this.request.setStatus(Request.RequestStatus.in_progress);
            this.request.setTimestamp(new Date());
            this.request.setResultStatus(Request.ResultStatus.unknown);
            if (this.getRunner().getExtResultFile() != null) {
                this.request.setExtResultFile(this.runner.getExtResultFile().toString());
            }
            userName = StringUtils.isBlank((CharSequence)System.getProperty("user.name")) != false ? "unknown" : System.getProperty("user.name");
            this.request.setUser(userName);
            RequestProvider.getInstance().addRequest(this.request);
            this.displayRequestView();
            if (!this.headlessMode) {
                monitor.beginTask("Executing the command ...", -1);
            }
            try {
                output = this.runner.runTool();
                if (!this.headlessMode) {
                    monitor.done();
                }
                if (output == null) {
                    this.displayError(function.getName(), "Unexpected fully empty result");
                    this.jobFail("Unexpected fully empty result");
                    var11_6 = Status.CANCEL_STATUS;
                    return var11_6;
                }
                errorMessage = (String)output.getRight();
                if (!StringUtils.isBlank((CharSequence)errorMessage)) {
                    this.request.setNotes(errorMessage);
                }
                if (!this.runner.isSuccess((exitStatus = (Integer)output.getLeft()).intValue())) {
                    this.displayError(function.getName(), errorMessage);
                    this.jobFail(errorMessage);
                    this.runner.killToolRunnerProcess();
                    var11_7 = Status.CANCEL_STATUS;
                    return var11_7;
                }
                if (this.runner.getResultFile() != null) {
                    this.request.setResultFile(this.runner.getResultFile().toString());
                }
                if (this.runner instanceof OslcToolConsumer && (osclConsumer = (OslcToolConsumer)this.runner).getRequestUri() != null) {
                    this.request.setRequestUriAsString(osclConsumer.getRequestUri().toString());
                }
                if (this.getRunner().isAsynchronousExecution()) break block25;
                functionName = this.runner.getToolFunction().getName();
                resultProcessor = ResultProcessorFactory.getProcessor(functionName);
                if (resultProcessor == null) ** GOTO lbl59
                if (this.runner.getResultFile() != null) {
                    resultProcessor.setResultFile(this.runner.getResultFile());
                    resultProcessor.setExtResultFile(this.runner.getExtResultFile());
                }
                if (!resultProcessor.processResult()) {
                    this.jobFail("Error processing the command result");
                    this.runner.killToolRunnerProcess();
                    var11_8 = Status.CANCEL_STATUS;
                    return var11_8;
                }
                try {
                    if (!this.headlessMode) {
                        resultProcessor.displayResult();
                    }
lbl59:
                    // 4 sources

                    this.jobSucceed();
                }
                catch (TimeoutException v0) {
                    this.displayError(function.getName(), "Timeout expired. Try increasing the timeout in the preferences.");
                    this.jobTimeout("Timeout expired. Try increasing the timeout in the preferences.");
                    this.runner.killToolRunnerProcess();
                    var11_9 = Status.CANCEL_STATUS;
                    return var11_9;
                }
                catch (Exception v1) {
                    this.displayError(function.getName(), "Internal error while executing the command");
                    this.jobFail("Internal error while executing the command");
                    this.runner.killToolRunnerProcess();
                    var11_10 = Status.CANCEL_STATUS;
                    return var11_10;
                }
            }
            finally {
                this.request.setWorkingDir(this.runner.getSessionWorkspaceDir().toString());
                if (this.runner instanceof OslcToolConsumer && (osclConsumer = (OslcToolConsumer)this.runner).getRequestUri() != null) {
                    this.request.setRequestUriAsString(osclConsumer.getRequestUri().toString());
                }
                this.displayRequestView();
            }
        }
        return Status.OK_STATUS;
    }

    protected void displayError(String title, String errorMsg) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)title, (String)errorMsg);
        });
    }

    protected void canceling() {
        if (this.runner != null) {
            this.runner.killToolRunnerProcess();
        }
    }

    protected String getCheckerExecutable() {
        return null;
    }

    protected void jobSucceed() {
        this.requestEnd(Request.ResultStatus.available);
    }

    protected void jobFail(String errorMessage) {
        this.request.setNotes(errorMessage);
        this.requestEnd(Request.ResultStatus.failure);
        logger.error(errorMessage);
    }

    protected void jobTimeout(String errorMessage) {
        this.request.setNotes(errorMessage);
        this.requestEnd(Request.ResultStatus.timeout);
        logger.error(errorMessage);
    }

    protected void requestEnd(Request.ResultStatus status) {
        this.request.setStatus(Request.RequestStatus.completed);
        this.request.setDuration(Float.valueOf((float)this.getRunner().getExecutionDuration() / 1000.0f));
        this.request.setResultStatus(status);
    }

    protected void displayRequestView() {
        Display.getDefault().asyncExec(() -> {
            try {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                RequestView viewPart = (RequestView)activePage.showView("eu.fbk.tools.adapter.ui.views.request.RequestView", null, 2);
                if (viewPart != null) {
                    TableViewer requestViewer = viewPart.getViewer();
                    IContentProvider provider = requestViewer.getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    requestViewer.refresh();
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        });
    }
}

