/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.contract;

import eu.fbk.tools.adapter.ocra.CheckContractImplementation;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ContractImplementationParametersDialog
extends Dialog {
    private CheckContractImplementation function;
    private Combo timeModelCombo;
    private Combo algorithmTypeCombo;
    private Text contractNameText;
    private Text componentNameText;
    private Spinner boundLengthSpinner;
    private Button oldSmvFormatCheckBox;
    private Button asyncCheckBox;
    private Button disableAsyncConstraintsBox;
    private Boolean asyncExecution = false;
    private Boolean disableAsyncConstraints = false;
    private String[] timeModels = new String[]{OcraFunction.TimeModel.discrete.name(), OcraFunction.TimeModel.hybrid.name(), OcraFunction.TimeModel.timed.name()};
    private String[] algorithmTypes = new String[]{"", "auto", "bdd", "bmc", "ic3"};
    private boolean goAhead = false;

    public ContractImplementationParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public ContractImplementationParametersDialog(Shell parentShell, CheckContractImplementation function, Boolean asyncExecution, Boolean disableAsyncConstraints) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
        this.disableAsyncConstraints = disableAsyncConstraints == null ? false : disableAsyncConstraints;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Contract Implementation Parameters");
    }

    protected void okPressed() {
        try {
            this.function.setTimeModel(OcraFunction.TimeModel.valueOf((String)this.timeModelCombo.getItems()[this.timeModelCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        try {
            this.function.setAlgorithmType(OcraFunction.AlgorithmType.valueOf((String)this.algorithmTypeCombo.getItems()[this.algorithmTypeCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        this.function.setContractName(this.contractNameText.getText());
        this.function.setComponentName(this.componentNameText.getText());
        this.function.setBoundLength(Integer.valueOf(this.boundLengthSpinner.getSelection()));
        this.function.setOldSmvFormat(Boolean.valueOf(this.oldSmvFormatCheckBox.getSelection()));
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.disableAsyncConstraints = this.disableAsyncConstraintsBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        Label lblCheck = new Label(container2, 0);
        lblCheck.setText("Time Model");
        this.timeModelCombo = new Combo(container2, 8);
        this.timeModelCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.timeModelCombo, this.timeModels, this.function.getTimeModel() == null ? "" : this.function.getTimeModel().name());
        Label lblAlgorithm = new Label(container2, 0);
        lblAlgorithm.setText("Algorithm Type");
        this.algorithmTypeCombo = new Combo(container2, 8);
        this.algorithmTypeCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.algorithmTypeCombo, this.algorithmTypes, this.function.getAlgorithmType() == null ? "" : this.function.getAlgorithmType().name());
        Label lblContractName = new Label(container2, 0);
        lblContractName.setText("Contract Name");
        this.contractNameText = new Text(container2, 2052);
        this.contractNameText.setLayoutData((Object)new GridData(768));
        this.contractNameText.setText(StringUtils.isBlank((CharSequence)this.function.getContractName()) ? "" : this.function.getContractName());
        Label lblComponentName = new Label(container2, 0);
        lblComponentName.setText("Component Name");
        this.componentNameText = new Text(container2, 2052);
        this.componentNameText.setLayoutData((Object)new GridData(768));
        this.componentNameText.setText(StringUtils.isBlank((CharSequence)this.function.getComponentName()) ? "" : this.function.getComponentName());
        Label lblBoundLength = new Label(container2, 0);
        lblBoundLength.setText("Bound Length");
        this.boundLengthSpinner = new Spinner(container2, 2048);
        this.boundLengthSpinner.setMinimum(0);
        this.boundLengthSpinner.setMaximum(1000);
        this.boundLengthSpinner.setSelection(10);
        this.boundLengthSpinner.setIncrement(1);
        this.boundLengthSpinner.setPageIncrement(10);
        if (this.function.getBoundLength() != null) {
            this.boundLengthSpinner.setSelection(this.function.getBoundLength().intValue());
        }
        this.oldSmvFormatCheckBox = new Button(container, 32);
        this.oldSmvFormatCheckBox.setText("Old SMV format");
        this.oldSmvFormatCheckBox.setSelection(this.function.getOldSmvFormat() == null ? false : this.function.getOldSmvFormat());
        this.disableAsyncConstraintsBox = new Button(container, 32);
        this.disableAsyncConstraintsBox.setText("Disable Async Constraints");
        this.disableAsyncConstraintsBox.setSelection(this.disableAsyncConstraints.booleanValue());
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    public Boolean getDisableAsyncConstraints() {
        return this.disableAsyncConstraints;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

