/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.safety.AbstractSafetyAnalysisCommand;
import eu.fbk.tools.adapter.xsap.SynthesizeFd;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;

public class SynthesizeFdCommand
extends AbstractSafetyAnalysisCommand {
    private SynthesizeFd function;
    public static final String ID_PARAMETER_ALARM_PATH = "alarm_path";
    public static final String ID_PARAMETER_OBSERVABLES = "observables";
    public static final String ID_PARAMETER_STAND_ALONE = "stand_alone";
    public static final String ID_PARAMETER_COMPOSITION_SEMANTICS = "composition_semantics";
    public static final String ID_PARAMETER_OUTPUTFILE = "output_file";
    public static final String ID_PARAMETER_NO_DAG = "no_dag";

    public SynthesizeFdCommand() {
        this("Synthesize Fault Detector");
    }

    protected SynthesizeFdCommand(String commandDescription) {
        super(commandDescription);
    }

    @Override
    protected boolean initialize() {
        super.initialize();
        this.function = new SynthesizeFd();
        return true;
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String noDag;
        String standAlone;
        String outputFile;
        String compositionSemantics;
        String observables;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        String alarmPath = event.getParameter(ID_PARAMETER_ALARM_PATH);
        if (!StringUtils.isBlank((CharSequence)alarmPath)) {
            this.function.setAlarmPath(FileUtils.stringToURI((String)alarmPath));
        }
        if (!StringUtils.isBlank((CharSequence)(observables = event.getParameter(ID_PARAMETER_OBSERVABLES)))) {
            this.function.setObservables(FileUtils.stringToURI((String)observables));
        }
        if (!StringUtils.isBlank((CharSequence)(compositionSemantics = event.getParameter(ID_PARAMETER_COMPOSITION_SEMANTICS)))) {
            this.function.setCompositionSemantics(compositionSemantics);
        }
        if (!StringUtils.isBlank((CharSequence)(outputFile = event.getParameter(ID_PARAMETER_OUTPUTFILE)))) {
            this.function.setOutputFile(FileUtils.stringToURI((String)outputFile));
        }
        if (!StringUtils.isBlank((CharSequence)(standAlone = event.getParameter(ID_PARAMETER_STAND_ALONE)))) {
            this.function.setStandAlone(Boolean.valueOf(standAlone));
        }
        if (!StringUtils.isBlank((CharSequence)(noDag = event.getParameter(ID_PARAMETER_NO_DAG)))) {
            this.function.setNoDag(Boolean.valueOf(noDag));
        }
        return true;
    }
}

