/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.behaviour;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.nuxmv.CheckModel;
import eu.fbk.tools.adapter.nuxmv.NuxmvFunction;
import eu.fbk.tools.adapter.ui.commands.behaviour.AbstractCheckModelCommand;
import eu.fbk.tools.adapter.ui.dialog.behaviour.ModelCheckingParametersDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckModelCommand
extends AbstractCheckModelCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckModelCommand.class);
    private CheckModel function;

    public CheckModelCommand() {
        super("Check behaviour model");
    }

    @Override
    protected boolean initialize() {
        this.function = new CheckModel();
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        Runnable runnable;
        Display display;
        String algorithmType;
        String checkType;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        String isTimed = event.getParameter("timed");
        if (isTimed != null) {
            try {
                this.function.setTimed(Boolean.valueOf(isTimed).booleanValue());
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid timed parameter value, can't execute the command.");
                logger.error("Invalid timed parameter value: " + isTimed);
                return false;
            }
        }
        if ((checkType = event.getParameter("check_type")) != null) {
            try {
                this.function.setCheckType(NuxmvFunction.CheckType.valueOf((String)checkType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid check type parameter value, can't execute the command.");
                logger.error("Invalid check type parameter value: " + checkType);
                return false;
            }
        }
        if ((algorithmType = event.getParameter("algorithm_type")) != null) {
            try {
                this.function.setAlgorithmType(NuxmvFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
        }
        this.function.setFormula(event.getParameter("property"));
        this.function.setPropertyName(event.getParameter("property_name"));
        if (this.function.getCheckType() == null) {
            display = PlatformUI.getWorkbench().getDisplay();
            runnable = new Runnable(){

                @Override
                public void run() {
                    ModelCheckingParametersDialog dialog = new ModelCheckingParametersDialog(CheckModelCommand.this.activeShell, CheckModelCommand.this.function, CheckModelCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckModelCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        if (this.isDevelopmentModeEnabled()) {
            display = PlatformUI.getWorkbench().getDisplay();
            runnable = new Runnable(){

                @Override
                public void run() {
                    ModelCheckingParametersDialog dialog = new ModelCheckingParametersDialog(CheckModelCommand.this.activeShell, CheckModelCommand.this.function, CheckModelCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckModelCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

