/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands;

import eu.fbk.tools.adapter.ToolFunctionInventory;
import eu.fbk.tools.adapter.ui.commands.AbstractBaseCommand;
import eu.fbk.tools.adapter.ui.dialog.ShowVVResultParametersDialog;
import eu.fbk.tools.adapter.ui.preferences.PreferenceUtils;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.result.ResultProcessorFactory;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowVVResultCommand
extends AbstractBaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(ShowVVResultCommand.class);
    protected String functionName = null;
    protected String resultFileName = null;

    public ShowVVResultCommand() {
        super("Show V&V Result");
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.functionName = event.getParameter("function_name");
        if (!StringUtils.isBlank((CharSequence)this.functionName) && !new ToolFunctionInventory().getFunctions().contains(this.functionName)) {
            logger.error("Internal error: unsupported function name " + this.functionName);
            return false;
        }
        if (PreferenceUtils.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ShowVVResultParametersDialog dialog = new ShowVVResultParametersDialog(ShowVVResultCommand.this.activeShell, ShowVVResultCommand.this.functionName);
                    dialog.open();
                    if (dialog.goAhead()) {
                        ShowVVResultCommand.this.functionName = dialog.getFunctionName();
                    }
                }
            };
            display.syncExec(runnable);
        }
        if (StringUtils.isBlank((CharSequence)this.functionName)) {
            logger.error("Internal error: function name is null or empty");
            return false;
        }
        this.resultFileName = this.getFileNameParameter(event, "result_file", "*", "Choose the result file");
        if (StringUtils.isBlank((CharSequence)this.resultFileName)) {
            logger.error("Result file has not been specified.");
            return false;
        }
        if (!new File(this.resultFileName).exists()) {
            logger.error("Result file not exists.");
            return false;
        }
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.preprocessEvent(event)) {
            return null;
        }
        ResultProcessor processor = ResultProcessorFactory.getProcessor(this.functionName);
        if (processor != null) {
            processor.setResultFile(new File(this.resultFileName));
            processor.setExtResultFile(new File(this.resultFileName));
            if (processor.processResult()) {
                processor.displayResult();
            }
        }
        return null;
    }
}

