/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands;

import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ToolRunner;
import eu.fbk.tools.adapter.ToolRunnerFactory;
import eu.fbk.tools.adapter.oslc.OslcToolConsumer;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.ToolConsoleFactory;
import eu.fbk.tools.adapter.ui.commands.AbstractBaseCommand;
import eu.fbk.tools.adapter.ui.preferences.PreferenceUtils;
import eu.fbk.tools.adapter.ui.progress.ToolJob;
import java.io.File;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractToolCommand
extends AbstractBaseCommand {
    private static final Logger logger = LoggerFactory.getLogger(AbstractToolCommand.class);
    private final String toolName;
    private final String keyToolExecutable;
    private final String keyToolTimeout;
    protected Boolean asyncExecution = null;
    protected String extResultFileName = null;
    protected Boolean internalExecution = null;

    public AbstractToolCommand(String toolName, String commandDescription, String keyToolExecutable, String keyToolTimeout) {
        super(commandDescription);
        this.toolName = toolName;
        this.keyToolExecutable = keyToolExecutable;
        this.keyToolTimeout = keyToolTimeout;
        ToolConsoleFactory toolConsoleFactory = new ToolConsoleFactory();
        toolConsoleFactory.showConsole();
    }

    protected abstract ToolFunction getFunction();

    @Override
    protected boolean initialize() {
        this.asyncExecution = null;
        this.extResultFileName = null;
        return super.initialize();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.initialize()) {
            return null;
        }
        if (!this.preprocessEvent(event)) {
            return null;
        }
        if (!this.getFunction().validateParameters()) {
            this.displayError(this.getCommandDescription(), "Invalid function parameters combination, can't execute the command.");
            return null;
        }
        ToolRunner runner = this.prepareRunner(this.getFunction());
        if (runner == null) {
            return null;
        }
        if (this.asyncExecution != null) {
            if (this.asyncExecution.booleanValue() && !runner.supportAsynchronousExecution()) {
                this.displayError(this.getCommandDescription(), "Asynchronous execution is not supported");
                return null;
            }
            runner.setAsynchronousExecution(this.asyncExecution.booleanValue());
        }
        if (!StringUtils.isBlank((CharSequence)this.extResultFileName)) {
            runner.setExtResultFile(new File(this.extResultFileName));
        }
        ToolJob job = new ToolJob(this.getCommandDescription(), runner);
        if (BooleanUtils.isTrue((Boolean)this.internalExecution)) {
            job.setHeadlessMode(true);
        }
        job.setUser(true);
        job.schedule();
        if (BooleanUtils.isNotTrue((Boolean)this.asyncExecution)) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return job.getRequest();
    }

    public String getToolName() {
        return this.toolName;
    }

    protected String getToolExecutable() {
        return Activator.getDefault().getPreferenceStore().getString(this.keyToolExecutable);
    }

    protected int getCheckTimeout() {
        return Activator.getDefault().getPreferenceStore().getInt(this.keyToolTimeout);
    }

    protected boolean checkToolExecutable() {
        ToolRunner runner = ToolRunnerFactory.getToolRunner((String)this.toolName, (File)new File(this.getToolExecutable()));
        if (!runner.testToolExistence()) {
            this.displayError(this.getCommandDescription(), String.valueOf(this.toolName) + " executable not set or not found, please open the Preferences panel and fix it.");
            return false;
        }
        if (!runner.testToolExecutionPermission()) {
            this.displayError(this.getCommandDescription(), String.valueOf(this.toolName) + " can't be executed, please check the file permissions.");
            return false;
        }
        return true;
    }

    protected boolean isDevelopmentModeEnabled() {
        return PreferenceUtils.isDevelopmentModeEnabled();
    }

    protected boolean isOslcEnabled() {
        return PreferenceUtils.isOslcEnabled();
    }

    protected String getOslcServiceProviderRegistryUrl() {
        String url = PreferenceUtils.getOslcServiceProviderRegistryUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            this.displayError(this.getCommandDescription(), "The OSLC Service Provider Registry URL is not set or not found, please open the Preferences panel and fix it.");
            return null;
        }
        return url;
    }

    protected String getOslcAutomationServiceProviderId() {
        String serviceProviderId = PreferenceUtils.getOslcAutomationServiceProviderId(this.getFunction().getName());
        if (StringUtils.isBlank((CharSequence)serviceProviderId)) {
            String message = String.format("There is no OSLC Service Provider that supports the function [%s].\nPlease open the Preferences panel and fix it.", this.getFunction().getName());
            this.displayError(this.getCommandDescription(), message);
            return null;
        }
        return serviceProviderId;
    }

    protected ToolRunner prepareRunner(ToolFunction function) {
        ToolRunner runner;
        if (this.isOslcEnabled()) {
            String serviceProviderRegistryUrl = this.getOslcServiceProviderRegistryUrl();
            if (StringUtils.isBlank((CharSequence)serviceProviderRegistryUrl)) {
                logger.error("Can't find the service provider registry url");
                return null;
            }
            String serviceProviderId = this.getOslcAutomationServiceProviderId();
            if (StringUtils.isBlank((CharSequence)serviceProviderId)) {
                logger.error("Can't find the service provider id for the plan " + this.getFunction().getName());
                return null;
            }
            runner = new OslcToolConsumer(function.getName(), serviceProviderRegistryUrl, serviceProviderId);
        } else {
            runner = ToolRunnerFactory.getToolRunner((String)function.getToolName(), (File)new File(this.getToolExecutable()));
        }
        runner.setWorkspaceDir(new File(Activator.getDefault().getPreferenceStore().getString("tools.workspace")));
        runner.setToolFunction(function);
        runner.setTimeout(this.getCheckTimeout());
        return runner;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String internalExecutionParameter;
        String extResultFileParameter;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        String asyncExecutionParameter = event.getParameter("async_execution");
        if (!StringUtils.isBlank((CharSequence)asyncExecutionParameter)) {
            try {
                this.asyncExecution = Boolean.valueOf(asyncExecutionParameter);
                logger.debug("Set asynchronous execution to: " + asyncExecutionParameter);
            }
            catch (Exception e) {
                String msg = "Internal error: unexpected value of async_execution parameter: " + asyncExecutionParameter + ". Allowed values are: true, false.";
                this.displayError(this.getCommandDescription(), String.valueOf(msg) + "\nCan't execute the command.");
                logger.error(msg, (Throwable)e);
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)(extResultFileParameter = event.getParameter("result_file")))) {
            String normalizedExtResultFileName;
            block11: {
                try {
                    normalizedExtResultFileName = extResultFileParameter.replace("\"", "");
                    File parent = new File(normalizedExtResultFileName).getParentFile();
                    if (parent == null || parent.exists() && parent.canWrite()) break block11;
                    String msg = "Internal error: unexpected value result_file parameter: " + normalizedExtResultFileName + ". Parent dir not exists or is not writable";
                    this.displayError(this.getCommandDescription(), String.valueOf(msg) + ".\nCan't execute the command.");
                    logger.error(msg);
                    return false;
                }
                catch (Exception e) {
                    this.displayError(this.getCommandDescription(), "Internal error: unexpected value of result_file parameter, can't execute the command.");
                    logger.error("Invalid value of result_file parameter: " + this.extResultFileName, (Throwable)e);
                    return false;
                }
            }
            this.extResultFileName = normalizedExtResultFileName;
            logger.debug("Set result file to: " + this.extResultFileName);
        }
        if (!StringUtils.isBlank((CharSequence)(internalExecutionParameter = event.getParameter("internal_execution")))) {
            try {
                this.internalExecution = Boolean.valueOf(internalExecutionParameter);
                logger.debug("Set internal_execution to: " + internalExecutionParameter);
            }
            catch (Exception e) {
                String msg = "Internal error: unexpected value of internal_execution parameter: " + internalExecutionParameter + ". Allowed values are: true, false.";
                this.displayError(this.getCommandDescription(), String.valueOf(msg) + "\nCan't execute the command.");
                logger.error(msg, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

