/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.IntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.LongIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.RealValueImpl;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.RealValue;

public class IntIntegerValueImpl
extends IntegerValueImpl {
    private static final long serialVersionUID = -6577108495688855442L;
    private final int value;
    private BigInteger bigValue = null;

    public IntIntegerValueImpl(int value) {
        this.value = value;
    }

    @Override
    public @NonNull IntegerValue abs() {
        if (this.value >= 0) {
            return this;
        }
        if (this.value > Integer.MIN_VALUE) {
            return ValueUtil.integerValueOf(-this.value);
        }
        return ValueUtil.integerValueOf(0x80000000L);
    }

    @Override
    public @NonNull IntegerValue addInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            int sum = this.value + thatValue;
            if (this.value >= 0 ? thatValue >= 0 && sum >= 0 : thatValue <= 0 && sum <= 0) {
                return ValueUtil.integerValueOf(sum);
            }
            return ValueUtil.integerValueOf((long)this.value + (long)thatValue);
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return ValueUtil.integerValueOf((long)this.value + thatValue);
        }
        @NonNull BigInteger result = this.bigIntegerValue().add(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull Double asDouble() {
        @NonNull Double result = this.value;
        return result;
    }

    @Override
    public @NonNull Integer asInteger() {
        @NonNull Integer result = this.value;
        return result;
    }

    @Override
    public @NonNull Number asNumber() {
        return this.value;
    }

    @Override
    public @NonNull Object asObject() {
        @NonNull Integer result = this.value;
        return result;
    }

    @Override
    public @NonNull Object asUnboxedObject(@NonNull IdResolver idResolver) {
        @NonNull Integer result = this.value;
        return result;
    }

    @Override
    public @NonNull BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    public @NonNull BigInteger bigIntegerValue() {
        BigInteger bigValue2 = this.bigValue;
        if (bigValue2 != null) {
            return bigValue2;
        }
        @NonNull BigInteger bigValue3 = this.bigValue = BigInteger.valueOf(this.value);
        return bigValue3;
    }

    @Override
    public int commutatedCompareToInteger(@NonNull IntegerValue o) {
        try {
            if (o instanceof IntIntegerValueImpl) {
                int thatValue = ((IntIntegerValueImpl)o).intValue();
                return this.value < thatValue ? -1 : (this.value == thatValue ? 0 : 1);
            }
            if (o instanceof LongIntegerValueImpl) {
                long thatValue = ((LongIntegerValueImpl)o).longValue();
                return (long)this.value < thatValue ? -1 : ((long)this.value == thatValue ? 0 : 1);
            }
            return this.bigIntegerValue().compareTo(o.bigIntegerValue());
        }
        catch (InvalidValueException e) {
            return this.hashCode() - o.hashCode();
        }
    }

    @Override
    public @NonNull IntegerValue divInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("div zero", new Object[0]);
        }
        @NonNull BigInteger result = this.bigIntegerValue().divide(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull RealValue divideInteger(@NonNull IntegerValue right) {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(bigLeft, bigRight);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof IntIntegerValueImpl) {
                int thatValue = ((IntIntegerValueImpl)obj).intValue();
                return this.value == thatValue;
            }
            if (obj instanceof LongIntegerValueImpl) {
                long thatValue = ((LongIntegerValueImpl)obj).longValue();
                return (long)this.value == thatValue;
            }
            if (obj instanceof IntegerValue) {
                BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
                return this.bigIntegerValue().compareTo(bigIntegerValue) == 0;
            }
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return this.value >= 0;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public @NonNull IntegerValue maxInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return this.value >= thatValue ? this : right;
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return (long)this.value >= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    @Override
    public @NonNull IntegerValue minInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return this.value <= thatValue ? this : right;
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return (long)this.value <= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    @Override
    public @NonNull IntegerValue modInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("mod zero", new Object[0]);
        }
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return ValueUtil.integerValueOf(this.value % thatValue);
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return ValueUtil.integerValueOf((long)this.value % thatValue);
        }
        @NonNull BigInteger result = this.bigIntegerValue().remainder(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            long thatValue = ((IntIntegerValueImpl)right).intValue();
            return ValueUtil.integerValueOf((long)this.value * thatValue);
        }
        @NonNull BigInteger result = this.bigIntegerValue().multiply(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public @NonNull IntegerValue negate() {
        if (this.value > Integer.MIN_VALUE) {
            return ValueUtil.integerValueOf(-this.value);
        }
        return ValueUtil.integerValueOf(0x80000000L);
    }

    @Override
    public int signum() {
        return Integer.signum(this.value);
    }

    @Override
    public @NonNull IntegerValue subtractInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            int diff = this.value - thatValue;
            if (this.value >= 0 ? thatValue <= 0 && diff >= 0 : thatValue >= 0 && diff <= 0) {
                return ValueUtil.integerValueOf(diff);
            }
            return ValueUtil.integerValueOf((long)this.value - (long)thatValue);
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return ValueUtil.integerValueOf((long)this.value - thatValue);
        }
        @NonNull BigInteger result = this.bigIntegerValue().subtract(right.bigIntegerValue());
        return ValueUtil.integerValueOf(result);
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

