/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.pivot.internal.delegate.DelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.SemanticException;

public class ValidationBehavior
extends AbstractDelegatedBehavior<EClassifier, EValidator.ValidationDelegate.Registry, ValidationDelegate.Factory> {
    public static final @NonNull ValidationBehavior INSTANCE = new ValidationBehavior();
    public static final @NonNull String NAME = "validationDelegates";

    public Constraint getConstraint(@NonNull MetamodelManager metamodelManager, @NonNull EClassifier eClassifier, @NonNull String constraintName) throws OCLDelegateException {
        Constraint constraint;
        Resource ecoreMetamodel = ClassUtil.nonNullEMF(eClassifier.eResource());
        Ecore2AS ecore2as = Ecore2AS.getAdapter(ecoreMetamodel, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
        Type type = ecore2as.getCreated(Type.class, (EObject)eClassifier);
        if (type != null && (constraint = NameUtil.getNameable(((MetamodelManagerInternal)metamodelManager).getAllInvariants(type), constraintName)) != null) {
            return constraint;
        }
        throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, type, "constraint"));
    }

    @Override
    public  @Nullable ValidationDelegate.Factory getDefaultFactory() {
        return (ValidationDelegate.Factory)ValidationDelegate.Factory.Registry.INSTANCE.getValidationDelegate(this.getName());
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EValidator.ValidationDelegate.Registry getDefaultRegistry() {
        return ClassUtil.nonNullEMF(ValidationDelegate.Factory.Registry.INSTANCE);
    }

    @Override
    public @NonNull EPackage getEPackage(@NonNull EClassifier eClassifier) {
        return ClassUtil.nonNullEMF(eClassifier.getEPackage());
    }

    @Override
    public  @Nullable ValidationDelegate.Factory getFactory(@NonNull DelegateDomain delegateDomain, @NonNull EClassifier eClassifier) {
        Class<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull EValidator.ValidationDelegate.Registry> castClass = EValidator.ValidationDelegate.Registry.class;
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull EValidator.ValidationDelegate.Registry registry = OCLDelegateDomain.getDelegateResourceSetRegistry((EModelElement)eClassifier, castClass, this.getDefaultRegistry());
        String delegateURI = delegateDomain.getURI();
        EValidator.ValidationDelegate validationDelegate = registry.getValidationDelegate(delegateURI);
        return (ValidationDelegate.Factory)validationDelegate;
    }

    @Override
    public @NonNull Class<ValidationDelegate.Factory> getFactoryClass() {
        return ValidationDelegate.Factory.class;
    }

    @Override
    public @NonNull String getName() {
        return NAME;
    }

    public @NonNull ExpressionInOCL getQueryOrThrow(@NonNull MetamodelManager metamodelManager, @NonNull Constraint constraint) throws OCLDelegateException {
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, constraint, "constraint"));
        }
        try {
            return metamodelManager.parseSpecification(specification);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e);
        }
    }

    @Override
    public @NonNull Class<ValidationDelegate.Factory.Registry> getRegistryClass() {
        return ValidationDelegate.Factory.Registry.class;
    }
}

