/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.contract.expression.validation;

import eu.fbk.tools.editor.contract.expression.validation.ProposalProvider;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PortProposalProvider
extends ProposalProvider {
    protected static PortProposalProvider instance;
    private final Map<String, PortInfo> ports = new Hashtable<String, PortInfo>();
    private final Map<String, List<String>> componentsToType = new Hashtable<String, List<String>>();

    protected PortProposalProvider() {
    }

    public static synchronized PortProposalProvider getInstance() {
        if (instance == null) {
            instance = new PortProposalProvider();
        }
        return instance;
    }

    public void addPort(String component, String port, PortInfo info) {
        if (component != null && !component.isEmpty()) {
            this.ports.put(String.valueOf(component) + "." + port, info);
        } else {
            this.ports.put(port, info);
        }
    }

    public void addPort(String port, PortInfo info) {
        this.addPort(null, port, info);
    }

    public Map<String, PortInfo> getPorts() {
        return Collections.unmodifiableMap(this.ports);
    }

    @Override
    public void clear() {
        this.ports.clear();
    }

    public void clearPorts() {
        this.ports.clear();
    }

    public Map<String, List<String>> getComponentsToType() {
        return this.componentsToType;
    }

    public static enum PortDirection {
        IN,
        OUT,
        IN_OUT;

    }

    public static class PortInfo
    extends ProposalProvider.VariableInfo {
        public PortDirection direction;

        public PortInfo(PortDirection direction, ProposalProvider.VariableType type) {
            super(type);
            this.direction = direction;
        }
    }
}

