/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.patterns.apply.ApplyPattern;
import org.polarsys.chess.patterns.dialogs.ConnectorMappingDialog;
import org.polarsys.chess.patterns.dialogs.PortMappingDialog;
import org.polarsys.chess.patterns.dialogs.PropertyMappingDialog;
import org.polarsys.chess.patterns.dialogs.SelectDesignPatternDialog;
import org.polarsys.chess.patterns.dialogs.TypeMappingDialog;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class ApplyDesignPatternCommand
extends AbstractHandler {
    private static final String[] STEPS = new String[]{"selection", "types", "ports", "properties", "connectors"};
    private int currentStep = 0;
    private Pattern pattern = null;
    private Class modelCtx = null;
    private Image patternPreview = null;
    private Map<NamedElement, NamedElement> mappings = null;
    private boolean cancelled = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            if (((StructuredSelection)selection).size() == 1) {
                EObject eobj;
                Object selectedElem = ((StructuredSelection)selection).getFirstElement();
                if (selectedElem instanceof EObjectTreeElement && (eobj = ((EObjectTreeElement)selectedElem).getEObject()) instanceof Class) {
                    this.modelCtx = (Class)eobj;
                }
            } else {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)shell, (String)"Select and Apply Design Pattern", (String)" this command should be called only on a single (composed) Class");
                    }
                });
                return null;
            }
        }
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        Model chessModel = null;
        try {
            Resource chessResource = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
            chessModel = (Model)chessResource.getContents().get(0);
            if (chessModel != null) {
                this.currentStep = 0;
                this.cancelled = false;
                while (this.currentStep < STEPS.length && !this.cancelled) {
                    this.performStep(shell, chessModel);
                }
                if (this.currentStep == STEPS.length && !this.cancelled) {
                    ApplyPattern applyPattern = new ApplyPattern(this.mappings, this.pattern, this.modelCtx);
                    applyPattern.apply();
                }
            }
        }
        catch (ServiceException e) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)"Select and Apply a Design Pattern", (String)("Unable to open the CHESS model: " + e.getMessage()));
                }
            });
        }
        catch (Exception e) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)"Select and Apply Design Pattern", (String)("Error during the execution of the command: " + e.getMessage()));
                }
            });
            e.printStackTrace();
        }
        return null;
    }

    private void performStep(Shell shell, Model chessModel) {
        switch (this.currentStep) {
            case 0: {
                SelectDesignPatternDialog selectDesignPattern = new SelectDesignPatternDialog(shell, chessModel);
                if (selectDesignPattern.open() == 0) {
                    this.pattern = selectDesignPattern.getSelectedPattern();
                    this.patternPreview = selectDesignPattern.getPatternPreview();
                    ++this.currentStep;
                    break;
                }
                this.cancelled = true;
                break;
            }
            case 1: {
                if (this.pattern == null) break;
                TypeMappingDialog mapTypesDialog = new TypeMappingDialog(shell, chessModel, this.pattern, this.modelCtx, this.patternPreview);
                int code = mapTypesDialog.open();
                if (code == 0) {
                    this.mappings = mapTypesDialog.getMappings();
                    ++this.currentStep;
                    break;
                }
                if (code == -1) {
                    --this.currentStep;
                    break;
                }
                this.cancelled = true;
                break;
            }
            case 2: {
                if (this.mappings == null || this.cancelled) break;
                PortMappingDialog mapPortsDialog = new PortMappingDialog(shell, chessModel, this.pattern, this.modelCtx, this.mappings, this.patternPreview);
                int code = mapPortsDialog.open();
                if (code == 0) {
                    this.mappings.putAll(mapPortsDialog.getMappings());
                    ++this.currentStep;
                    break;
                }
                if (code == -1) {
                    --this.currentStep;
                    break;
                }
                this.cancelled = true;
                break;
            }
            case 3: {
                if (this.mappings == null || this.cancelled) break;
                PropertyMappingDialog mapPropertyDialog = new PropertyMappingDialog(shell, chessModel, this.pattern, this.modelCtx, this.mappings, this.patternPreview);
                int code = mapPropertyDialog.open();
                if (code == 0) {
                    this.mappings.putAll(mapPropertyDialog.getMappings());
                    ++this.currentStep;
                    break;
                }
                if (code == -1) {
                    --this.currentStep;
                    break;
                }
                this.cancelled = true;
                break;
            }
            case 4: {
                if (this.mappings == null || this.cancelled) break;
                ConnectorMappingDialog mapConnectorDialog = new ConnectorMappingDialog(shell, chessModel, this.pattern, this.modelCtx, this.mappings, this.patternPreview);
                int code = mapConnectorDialog.open();
                if (code == 0) {
                    this.mappings.putAll(mapConnectorDialog.getMappings());
                    ++this.currentStep;
                    break;
                }
                if (code == -1) {
                    --this.currentStep;
                    break;
                }
                this.cancelled = true;
                break;
            }
        }
    }
}

