/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardTools.KratosExecService.ui.dialogs;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.widgets.StyledText;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class KratosParametersDialog
extends Dialog {
    AbstractSystemModel systemModel;
    private StyledText propertyText;
    private List<?> contextList;
    private String property;
    private CCombo chooseAnalysisCtxField;
    private SelectionListener modAnalysisCtxListener;
    private boolean goAhead = false;

    public KratosParametersDialog(final AbstractSystemModel systemModel, final List<?> contextList) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.contextList = contextList;
        this.systemModel = systemModel;
        this.setShellStyle(32);
        this.modAnalysisCtxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = KratosParametersDialog.this.chooseAnalysisCtxField.getSelectionIndex();
                if (selIndex != -1) {
                    Object ctx = contextList.get(selIndex);
                    KratosParametersDialog.this.propertyText.setText(systemModel.getModelCheckingAnalysisContextProperty(ctx));
                    KratosParametersDialog.this.propertyText.notifyListeners(2, new Event());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("kratos parameters");
    }

    protected void okPressed() {
        this.property = this.propertyText.getText();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd_combo = new GridData(768);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        container2.setLayoutData((Object)gd_combo);
        Label contextAnalysisLabel = new Label(container2, 0);
        contextAnalysisLabel.setText("Context Analysis");
        this.chooseAnalysisCtxField = new CCombo(container2, 2060);
        this.chooseAnalysisCtxField.setBackground(Display.getDefault().getSystemColor(1));
        for (Object ctx : this.contextList) {
            this.chooseAnalysisCtxField.add(this.systemModel.getAnalysisContextName(ctx));
        }
        this.chooseAnalysisCtxField.addSelectionListener(this.modAnalysisCtxListener);
        this.chooseAnalysisCtxField.setLayoutData((Object)gd_combo);
        Label lblProperty = new Label(container2, 0);
        lblProperty.setText("Property");
        this.propertyText = new StyledText(container2, 2052);
        this.propertyText.setLayoutData((Object)gd_combo);
        this.propertyText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    KratosParametersDialog.this.okPressed();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (KratosParametersDialog.this.propertyText.getText().length() > 0) {
                    KratosParametersDialog.this.getButton(0).setEnabled(true);
                } else {
                    KratosParametersDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(560, 260);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public String getProperty() {
        return this.property;
    }
}

