/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.fla.common.FlaAnalysisException;
import org.polarsys.chess.fla.common.FlaLogger;
import org.polarsys.chess.fla.common.TransformationException;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.analysis.FlaSystem;
import org.polarsys.chess.fla.preferences.FlaParameters;
import org.polarsys.chess.fla.transformations.QVToTransformation;

public class FlaAnalysisRunner
implements IRunnableWithProgress {
    protected static final String FLA_MM_EXTENSION = "flamm";
    protected static final String FLA_XML_EXTENSION = "flaxml";
    protected IContainer targetFolder;
    protected FlaSystem analyzedSystem;
    protected URI chessModelUri;
    protected Resource chessResource;
    protected Resource flaResource;
    protected String rootComponentQualifiedName = "";
    protected DiagramEditPart diagramEditPart;

    public IContainer getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(IContainer targetFolder) {
        this.targetFolder = targetFolder;
    }

    public URI getModelURI() {
        return this.chessModelUri;
    }

    public void setModelURI(URI modelURI) {
        this.chessModelUri = modelURI;
    }

    public void setRootComponent(String rootComponentQualifiedName) {
        this.rootComponentQualifiedName = rootComponentQualifiedName;
    }

    public Resource getChessResource() {
        return this.chessResource;
    }

    public void setChessResource(Resource chessResource) {
        this.chessResource = chessResource;
    }

    public void setDiagramEditPart(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Running Failure Logic Analysis...", 4);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.subTask("Performing model transformations...");
            this.runInput2FlaTransformation(monitor);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.subTask("Applying failure propagation...");
            this.analyzeModel(this.flaResource);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.subTask("Propagating analysis results to the model...");
            this.backpropagateAnalysisResults(this.analyzedSystem, monitor);
            this.createOutputXmlFile(this.analyzedSystem, monitor);
            monitor.worked(1);
            monitor.subTask("Specializing the results...");
            this.specializeAnalysisResults(monitor);
            Thread.sleep(1000L);
        }
        catch (TransformationException transformationException) {
            CHESSProjectSupport.printlnToCHESSConsole((String)"*** Error running FLA transformation ***");
            this.showErrorMessage("FLA Analysis", "Error during FLA transformation");
            return;
        }
        catch (FlaAnalysisException e) {
            CHESSProjectSupport.printlnToCHESSConsole((String)"*** Error running FLA Analysis ***");
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            this.showErrorMessage("FLA Analysis", "Error during FLA analysis");
            return;
        }
        CHESSProjectSupport.printlnToCHESSConsole((String)"*** Concerto-FLA analysis was performed successfully ***");
        monitor.done();
    }

    protected void analyzeModel(Resource resource) throws FlaAnalysisException {
        this.analyzeModel((Component)resource.getContents().get(0));
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new FlaAnalysisException(e);
        }
    }

    protected void analyzeModel(Component component) throws FlaAnalysisException {
        FlaSystem system = new FlaSystem(component);
        this.analyzeModel(system);
    }

    protected void analyzeModel(FlaSystem system) throws FlaAnalysisException {
        this.setPreferences(system);
        FlaLogger logger = new FlaLogger();
        system.performAnalysis((org.polarsys.chess.fla.flamm.analysis.FlaLogger)logger);
        if (!logger.getWarnings().isEmpty()) {
            this.showErrorMessages("Warnings during analysis", logger.getWarnings());
        }
        this.analyzedSystem = system;
    }

    protected void setPreferences(FlaSystem system) {
        FlaParameters params = FlaParameters.getCurrentParameters();
        system.initializeNoFailure(params.getInitNoFailure());
        system.propagateUnmatchedFailures(params.getPropagateUnmatchedFailures());
        system.treatUnmentionedPortsAsWildcards(params.getTreatUnmentionedPortsAsWildcards());
    }

    protected void createOutputXmlFile(FlaSystem system, IProgressMonitor monitor) {
        String xmlPath = this.getOutputXmlPath();
        File outputFile = new File(xmlPath);
        outputFile.delete();
        try {
            this.runFla2XmlTransformation(monitor);
        }
        catch (TransformationException e) {
            e.printStackTrace();
        }
    }

    protected void backpropagateAnalysisResults(FlaSystem system, IProgressMonitor monitor) {
        try {
            this.runBackpropagationTransformation(monitor);
        }
        catch (TransformationException e) {
            e.printStackTrace();
        }
    }

    protected void specializeAnalysisResults(IProgressMonitor monitor) {
        try {
            this.runSpecializeAnalysisTransformation(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void runSpecializeAnalysisTransformation(IProgressMonitor monitor) {
        QVToTransformation transformation = new QVToTransformation();
        transformation.performChess2FlaMMSpecialization(this.chessResource, this.flaResource, monitor, String.valueOf(this.rootComponentQualifiedName) + "_instSpec");
    }

    protected void runInput2FlaTransformation(IProgressMonitor monitor) throws TransformationException {
        FlammPackage.eINSTANCE.getClass();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI flaMMuri = this.createFlaModelUri().appendFileExtension(FLA_MM_EXTENSION);
        new File(flaMMuri.path()).delete();
        this.flaResource = resourceSet.createResource(flaMMuri);
        QVToTransformation transformation = new QVToTransformation();
        transformation.performChess2ConcertoFlaTransformation(this.chessResource, this.flaResource, monitor, String.valueOf(this.rootComponentQualifiedName) + "_instSpec");
        if (this.flaResource.getContents() == null || this.flaResource.getContents().isEmpty()) {
            throw new TransformationException();
        }
    }

    protected void runFla2XmlTransformation(IProgressMonitor monitor) throws TransformationException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI xmlUri = this.createFlaModelUri().appendFileExtension(FLA_XML_EXTENSION);
        Resource xmlResource = resourceSet.createResource(xmlUri);
        xmlResource.setURI(xmlUri.trimFileExtension().appendFileExtension("xml"));
        QVToTransformation transformation = new QVToTransformation();
        transformation.performConcertoFla2ConcertoFlaXMLTransformation(this.flaResource, xmlResource, monitor);
    }

    protected void runBackpropagationTransformation(IProgressMonitor monitor) throws TransformationException {
        QVToTransformation transformation = new QVToTransformation();
        transformation.performConcertoFla2ChessBackPropagation(this.flaResource, this.chessResource, monitor, String.valueOf(this.rootComponentQualifiedName) + "_instSpec", this.diagramEditPart);
    }

    protected URI createFlaModelUri() {
        String modelName = this.getModelName();
        String flaPath = String.valueOf(this.targetFolder.getFullPath().toString()) + "/" + modelName + "." + this.rootComponentQualifiedName.replaceAll("::", ".") + "_result";
        return URI.createPlatformResourceURI((String)flaPath, (boolean)false);
    }

    protected String getOutputXmlPath() {
        String modelName = this.getModelName();
        return this.targetFolder.getLocation().append(String.valueOf(modelName) + "_result.xml").toString();
    }

    protected String getModelName() {
        return this.chessModelUri.lastSegment().substring(0, this.chessModelUri.lastSegment().lastIndexOf(46));
    }

    protected void showErrorMessages(String title, List<String> messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(String.valueOf(message) + "\n");
        }
        this.showErrorMessage(title, sb.toString());
    }

    protected void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, title, 0);
    }
}

