/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.c.formatting2;

import com.google.inject.Inject;
import eu.fbk.tools.editor.c.c.FunctionDefinition;
import eu.fbk.tools.editor.c.c.TranslationUnit;
import eu.fbk.tools.editor.c.expression.expression.AssignmentExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalAndExpression;
import eu.fbk.tools.editor.c.expression.expression.LogicalOrExpression;
import eu.fbk.tools.editor.c.services.CGrammarAccess;
import eu.fbk.tools.editor.c.statement.formatting2.StatementFormatter;
import eu.fbk.tools.editor.c.statement.statement.CompoundStatement;
import eu.fbk.tools.editor.c.statement.statement.Declaration;
import eu.fbk.tools.editor.c.statement.statement.DeclarationList;
import eu.fbk.tools.editor.c.statement.statement.StatementList;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

public class CFormatter
extends StatementFormatter {
    @Inject
    @Extension
    private CGrammarAccess _cGrammarAccess;

    protected void _format(TranslationUnit translationUnit, @Extension IFormattableDocument document) {
        EList<EObject> _list = translationUnit.getList();
        for (EObject eObject : _list) {
            document.format((Object)eObject);
        }
    }

    protected void _format(FunctionDefinition functionDefinition, @Extension IFormattableDocument document) {
        document.format((Object)functionDefinition.getSpecifier());
        document.format((Object)functionDefinition.getDeclator());
        document.format((Object)functionDefinition.getStatement());
    }

    public void format(Object functionDefinition, IFormattableDocument document) {
        if (functionDefinition instanceof XtextResource) {
            this._format((XtextResource)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof AssignmentExpression) {
            this._format((AssignmentExpression)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof LogicalAndExpression) {
            this._format((LogicalAndExpression)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof LogicalOrExpression) {
            this._format((LogicalOrExpression)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof CompoundStatement) {
            this._format((CompoundStatement)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof FunctionDefinition) {
            this._format((FunctionDefinition)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof TranslationUnit) {
            this._format((TranslationUnit)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof Declaration) {
            this._format((Declaration)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof DeclarationList) {
            this._format((DeclarationList)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof StatementList) {
            this._format((StatementList)functionDefinition, document);
            return;
        }
        if (functionDefinition instanceof EObject) {
            this._format((EObject)functionDefinition, document);
            return;
        }
        if (functionDefinition == null) {
            this._format(null, document);
            return;
        }
        if (functionDefinition != null) {
            this._format(functionDefinition, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(functionDefinition, document).toString());
    }
}

