/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.services;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class BaseValueConverterService
extends AbstractDeclarativeValueConverterService {
    private BinaryOperatorNameConverter binaryOperatorNameConverter = null;
    private static DoubleQuotedStringConverter doubleQuotedStringConverter = null;
    private static EscapedIDConverter escapedIDConverter = null;
    private IDConverter idConverter = null;
    private static MultiLineSingleQuotedStringConverter multiLineSingleQuotedStringConverter = null;
    private NameConverter nameConverter = null;
    private static NumberConverter numberConverter = null;
    private static SimpleIDConverter simpleIDConverter = null;
    private static SingleQuotedStringConverter singleQuotedStringConverter = null;
    private static UnquotedStringConverter unquotedStringConverter = null;
    private UnreservedNameConverter unreservedNameConverter = null;
    private UnrestrictedNameConverter unrestrictedNameConverter = null;
    private static SingleQuotedStringConverter uriConverter = null;

    public static String escapeIdentifier(String value) {
        return "_'" + value + "'";
    }

    public static Set<String> getAllKeywords(Grammar g, String name, boolean validIdentifiersOnly) {
        HashSet<String> kws = new HashSet<String>();
        List rules = GrammarUtil.allParserRules((Grammar)g);
        for (ParserRule parserRule : rules) {
            if (!parserRule.getName().equals(name)) continue;
            BaseValueConverterService.getAllKeywords(kws, (AbstractRule)parserRule, validIdentifiersOnly);
        }
        return kws;
    }

    private static void getAllKeywords(Set<String> kws, AbstractRule parserRule, boolean validIdentifiersOnly) {
        TreeIterator tit = parserRule.eAllContents();
        while (tit.hasNext()) {
            Object ele = tit.next();
            if (ele instanceof Keyword) {
                String value = ((Keyword)ele).getValue();
                if (validIdentifiersOnly && !PivotUtilInternal.isValidIdentifier((String)value)) continue;
                kws.add(value);
                continue;
            }
            if (!(ele instanceof RuleCall)) continue;
            BaseValueConverterService.getAllKeywords(kws, ((RuleCall)ele).getRule(), validIdentifiersOnly);
        }
    }

    @ValueConverter(rule="BinaryOperatorName")
    public IValueConverter<String> BinaryOperatorName() {
        if (this.binaryOperatorNameConverter == null) {
            this.binaryOperatorNameConverter = new BinaryOperatorNameConverter(this.getGrammar());
        }
        return this.binaryOperatorNameConverter;
    }

    @ValueConverter(rule="DOUBLE_QUOTED_STRING")
    public IValueConverter<String> DOUBLE_QUOTED_STRING() {
        if (doubleQuotedStringConverter == null) {
            doubleQuotedStringConverter = new DoubleQuotedStringConverter();
        }
        return doubleQuotedStringConverter;
    }

    @ValueConverter(rule="ESCAPED_ID")
    public IValueConverter<String> ESCAPED_ID() {
        if (escapedIDConverter == null) {
            escapedIDConverter = new EscapedIDConverter();
        }
        return escapedIDConverter;
    }

    @ValueConverter(rule="ID")
    public IValueConverter<String> ID() {
        if (this.idConverter == null) {
            this.idConverter = new IDConverter(this.getGrammar());
        }
        return this.idConverter;
    }

    @ValueConverter(rule="Identifier")
    public IValueConverter<String> Identifier() {
        return this.ID();
    }

    @ValueConverter(rule="ML_SINGLE_QUOTED_STRING")
    public IValueConverter<String> ML_SINGLE_QUOTED_STRING() {
        if (multiLineSingleQuotedStringConverter == null) {
            multiLineSingleQuotedStringConverter = new MultiLineSingleQuotedStringConverter();
        }
        return multiLineSingleQuotedStringConverter;
    }

    @ValueConverter(rule="Name")
    public IValueConverter<String> Name() {
        if (this.nameConverter == null) {
            this.nameConverter = new NameConverter(this.getGrammar());
        }
        return this.nameConverter;
    }

    @ValueConverter(rule="NUMBER_LITERAL")
    public IValueConverter<Number> NUMBER_LITERAL() {
        if (numberConverter == null) {
            numberConverter = new NumberConverter();
        }
        return numberConverter;
    }

    @ValueConverter(rule="SIMPLE_ID")
    public IValueConverter<String> SIMPLE_ID() {
        if (simpleIDConverter == null) {
            simpleIDConverter = new SimpleIDConverter();
        }
        return simpleIDConverter;
    }

    @ValueConverter(rule="SINGLE_QUOTED_STRING")
    public IValueConverter<String> SINGLE_QUOTED_STRING() {
        if (singleQuotedStringConverter == null) {
            singleQuotedStringConverter = new SingleQuotedStringConverter();
        }
        return singleQuotedStringConverter;
    }

    @ValueConverter(rule="StringLiteral")
    public IValueConverter<String> StringLiteral() {
        return this.SINGLE_QUOTED_STRING();
    }

    @ValueConverter(rule="UNQUOTED_STRING")
    public IValueConverter<String> UNQUOTED_STRING() {
        if (unquotedStringConverter == null) {
            unquotedStringConverter = new UnquotedStringConverter();
        }
        return unquotedStringConverter;
    }

    @ValueConverter(rule="URI")
    public IValueConverter<String> URI() {
        if (uriConverter == null) {
            uriConverter = new SingleQuotedStringConverter();
        }
        return uriConverter;
    }

    @ValueConverter(rule="UnreservedName")
    public IValueConverter<String> UnreservedName() {
        if (this.unreservedNameConverter == null) {
            this.unreservedNameConverter = new UnreservedNameConverter(this.getGrammar());
        }
        return this.unreservedNameConverter;
    }

    @ValueConverter(rule="UnrestrictedName")
    public IValueConverter<String> UnrestrictedName() {
        if (this.unrestrictedNameConverter == null) {
            this.unrestrictedNameConverter = new UnrestrictedNameConverter(this.getGrammar());
        }
        return this.unrestrictedNameConverter;
    }

    protected static abstract class AbstractIDConverter
    extends AbstractNullSafeConverter<String> {
        protected AbstractIDConverter() {
        }

        protected String internalToValue(String string, INode node) {
            int length = string.length();
            if (string.startsWith("_'") && length >= 3 && string.endsWith("'")) {
                return string.substring(2, length - 1);
            }
            if (string.startsWith("'") && length >= 2 && string.endsWith("'")) {
                return string.substring(1, length - 1);
            }
            if (string.startsWith("\"") && length >= 2 && string.endsWith("\"")) {
                return string.substring(1, length - 1);
            }
            return string;
        }
    }

    protected static class BinaryOperatorNameConverter
    implements IValueConverter<String> {
        private final Set<String> navigationOperatorNameKeywords;

        protected static Set<String> computeKeywords(Grammar grammar) {
            Set<String> keywords = BaseValueConverterService.getAllKeywords(grammar, "NavigationOperatorName", false);
            return keywords;
        }

        public BinaryOperatorNameConverter(Grammar grammar) {
            this.navigationOperatorNameKeywords = BinaryOperatorNameConverter.computeKeywords(grammar);
        }

        public String toValue(String string, INode node) {
            return string.trim();
        }

        public String toString(String value) {
            if (this.navigationOperatorNameKeywords.contains(value)) {
                return value.toString();
            }
            return " " + value.toString() + " ";
        }
    }

    protected static class DoubleQuotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected DoubleQuotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                String result = string.substring(1, string.length() - 1);
                assert (result != null);
                return StringUtil.convertFromOCLString((String)result);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return String.valueOf('\"') + StringUtil.convertToOCLString((String)value) + '\"';
        }
    }

    protected static class EscapedIDConverter
    extends AbstractIDConverter {
        protected EscapedIDConverter() {
        }

        protected String internalToString(String value) {
            return value;
        }
    }

    protected static class IDConverter
    extends AbstractIDConverter {
        private final Set<String> allKeywords;

        public IDConverter(Grammar grammar) {
            this.allKeywords = GrammarUtil.getAllKeywords((Grammar)grammar);
        }

        protected String internalToString(String value) {
            if (this.allKeywords.contains(value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtilInternal.isValidIdentifier((String)value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }

    protected static class MultiLineSingleQuotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected MultiLineSingleQuotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                String result = string.substring(2, string.length() - 2);
                assert (result != null);
                return StringUtil.convertFromOCLString((String)result);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return "'" + StringUtil.convertToOCLString((String)value) + "'";
        }
    }

    protected static class NameConverter
    extends AbstractIDConverter {
        private final Set<String> nameKeywords;

        protected static Set<String> computeKeywords(Grammar grammar) {
            HashSet<String> keywords = new HashSet<String>(GrammarUtil.getAllKeywords((Grammar)grammar));
            keywords.removeAll(BaseValueConverterService.getAllKeywords(grammar, "UnrestrictedName", true));
            keywords.removeAll(BaseValueConverterService.getAllKeywords(grammar, "EssentialOCLReservedKeyword", true));
            keywords.removeAll(BaseValueConverterService.getAllKeywords(grammar, "RestrictedKeywords", true));
            keywords.removeAll(BaseValueConverterService.getAllKeywords(grammar, "CollectionTypeIdentifier", true));
            keywords.removeAll(BaseValueConverterService.getAllKeywords(grammar, "PrimitiveTypeIdentifier", true));
            return keywords;
        }

        public NameConverter(Grammar grammar) {
            this.nameKeywords = NameConverter.computeKeywords(grammar);
        }

        protected String internalToString(String value) {
            if (this.nameKeywords.contains(value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtilInternal.isValidIdentifier((String)value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }

    protected static class NumberConverter
    implements IValueConverter<Number> {
        protected NumberConverter() {
        }

        public Number toValue(String string, INode node) {
            if (Strings.isEmpty((String)string)) {
                throw new ValueConverterException("Couldn't convert empty string to number", node, null);
            }
            try {
                if (string.contains(".") || string.contains("e") || string.contains("e")) {
                    return new BigDecimal(string);
                }
                return new BigInteger(string);
            }
            catch (NumberFormatException e) {
                throw new ValueConverterException("Couldn't convert '" + string + "' to number", node, (Exception)e);
            }
        }

        public String toString(Number value) {
            return value.toString();
        }
    }

    protected static class SimpleIDConverter
    extends AbstractNullSafeConverter<String> {
        protected SimpleIDConverter() {
        }

        protected String internalToValue(String string, INode node) {
            return string;
        }

        protected String internalToString(String value) {
            return value;
        }
    }

    protected static class SingleQuotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected SingleQuotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                String result = string.substring(1, string.length() - 1);
                assert (result != null);
                return StringUtil.convertFromOCLString((String)result);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return "'" + StringUtil.convertToOCLString((String)value) + "'";
        }
    }

    protected static class UnquotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected UnquotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                String result = string.substring(1, string.length() - 1);
                assert (result != null);
                return StringUtil.convertFromOCLString((String)result);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            int lastNewLine;
            int lastComment = (value = value.replace("\r", "")).lastIndexOf("--");
            if (lastComment >= 0 && (lastNewLine = value.lastIndexOf("\n")) < lastComment) {
                value = String.valueOf(value) + "\n";
            }
            return value;
        }
    }

    protected static class UnreservedNameConverter
    extends AbstractIDConverter {
        private final Set<String> reservedKeywords;

        protected static Set<String> computeReservedKeywords(Grammar grammar) {
            HashSet<String> keywords = new HashSet<String>(GrammarUtil.getAllKeywords((Grammar)grammar));
            Set<String> unreservedNames = BaseValueConverterService.getAllKeywords(grammar, "UnreservedName", true);
            keywords.removeAll(unreservedNames);
            return keywords;
        }

        public UnreservedNameConverter(Grammar grammar) {
            this.reservedKeywords = UnreservedNameConverter.computeReservedKeywords(grammar);
        }

        protected String internalToString(String value) {
            if (this.reservedKeywords.contains(value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtilInternal.isValidIdentifier((String)value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }

    protected static class UnrestrictedNameConverter
    extends AbstractIDConverter {
        private final Set<String> restrictedKeywords;

        protected static Set<String> computeRestrictedKeywords(Grammar grammar) {
            HashSet<String> keywords = new HashSet<String>(GrammarUtil.getAllKeywords((Grammar)grammar));
            Set<String> unrestrictedNames = BaseValueConverterService.getAllKeywords(grammar, "UnrestrictedName", true);
            keywords.removeAll(unrestrictedNames);
            return keywords;
        }

        public UnrestrictedNameConverter(Grammar grammar) {
            this.restrictedKeywords = UnrestrictedNameConverter.computeRestrictedKeywords(grammar);
        }

        protected String internalToString(String value) {
            if (this.restrictedKeywords.contains(value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtilInternal.isValidIdentifier((String)value)) {
                return BaseValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }
}

