/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETEmitter {
    protected String projectName = ".JETEmitters";
    protected Method method;
    protected Object object;
    protected String[] templateURIPath;
    protected String templateURI;
    protected ClassLoader classLoader;
    protected String encoding;
    protected List<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
    protected Map<String, String> javaOptions = new HashMap<String, String>();

    public JETEmitter(String templateURI) {
        this.templateURI = templateURI;
        this.classLoader = this.getClass().getClassLoader();
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = this.getClass().getClassLoader();
    }

    public JETEmitter(String templateURI, ClassLoader classLoader) {
        this.templateURI = templateURI;
        this.classLoader = classLoader;
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = classLoader;
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader, String encoding) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = classLoader;
        this.encoding = encoding;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<IClasspathEntry> getClasspathEntries() {
        return this.classpathEntries;
    }

    public Map<String, String> getJavaOptions() {
        return this.javaOptions;
    }

    public Object getObject() {
        return this.object;
    }

    public Object getObject(String lineDelimiter) {
        if (lineDelimiter != null) {
            Class<?> javaClass;
            if (this.object != null) {
                javaClass = this.object.getClass();
                try {
                    Field field = javaClass.getField("NL");
                    Object nl = field.get(this.object);
                    if (lineDelimiter.equals(nl)) {
                        return this.object;
                    }
                    this.object = null;
                }
                catch (Throwable exception) {
                    CodeGenPlugin.INSTANCE.log(exception);
                }
            }
            if (this.object == null && this.method != null) {
                javaClass = this.method.getDeclaringClass();
                try {
                    Method method = javaClass.getMethod("create", String.class);
                    this.object = method.invoke(null, lineDelimiter);
                }
                catch (Throwable exception) {
                    CodeGenPlugin.INSTANCE.log(exception);
                }
            }
        }
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        if ((method.getModifiers() & 8) == 0 && this.object == null) {
            try {
                this.object = method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException exception) {
                CodeGenPlugin.INSTANCE.log(exception);
            }
            catch (InstantiationException exception) {
                CodeGenPlugin.INSTANCE.log(exception);
            }
        }
    }

    public void initialize(IProgressMonitor progressMonitor) throws JETException {
        this.initialize(BasicMonitor.toMonitor((IProgressMonitor)progressMonitor));
    }

    public void initialize(Monitor progressMonitor) throws JETException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.initialize(progressMonitor, this);
        }
    }

    public void addVariable(String variableName, String pluginID) throws JETException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && this.method == null) {
            EclipseHelper.addVariable(this, variableName, pluginID);
        }
    }

    public String generate(IProgressMonitor progressMonitor, Object[] arguments) throws JETException {
        return this.generate(BasicMonitor.toMonitor((IProgressMonitor)progressMonitor), arguments);
    }

    public String generate(Monitor progressMonitor, Object[] arguments) throws JETException {
        return this.generate(progressMonitor, arguments, null);
    }

    public String generate(Monitor progressMonitor, Object[] arguments, String lineDelimiter) throws JETException {
        if (this.method == null) {
            this.initialize(progressMonitor);
        }
        String result = "";
        if (this.method != null) {
            try {
                result = (String)this.method.invoke(this.getObject(lineDelimiter), arguments);
            }
            catch (IllegalAccessException exception) {
                throw new JETException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new JETException(exception);
            }
        }
        return result;
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public static void initialize(Monitor monitor, final JETEmitter jetEmitter) throws JETException {
            progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
            progressMonitor.beginTask("", 10);
            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_GeneratingJETEmitterFor_message", new Object[]{jetEmitter.templateURI}));
            workspace = ResourcesPlugin.getWorkspace();
            javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            try {
                jetCompiler = jetEmitter.templateURIPath == null ? new MyBaseJETCompiler(jetEmitter.templateURI, jetEmitter.encoding, jetEmitter.classLoader) : new MyBaseJETCompiler(jetEmitter.templateURIPath, jetEmitter.templateURI, jetEmitter.encoding, jetEmitter.classLoader);
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETParsing_message", new Object[]{jetCompiler.getResolvedTemplateURI()}));
                jetCompiler.parse();
                progressMonitor.worked(1);
                packageName = jetCompiler.getSkeleton().getPackageName();
                if (jetEmitter.templateURIPath == null) ** GOTO lbl-1000
                templateURI = URI.createURI((String)jetEmitter.templateURIPath[0]);
                theClassLoader /* !! */  = null;
                if (templateURI.isPlatformResource()) {
                    project = workspace.getRoot().getProject(templateURI.segment(1));
                    if (JETNature.getRuntime(project) != null) {
                        urls = new ArrayList<URL>();
                        javaProject = JavaCore.create((IProject)project);
                        urls.add(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
                        var15_15 = javaProject.getResolvedClasspath(true);
                        var14_16 = var15_15.length;
                        var13_19 = 0;
                        while (var13_19 < var14_16) {
                            classpathEntry = var15_15[var13_19];
                            if (classpathEntry.getEntryKind() == 2) {
                                projectPath = classpathEntry.getPath();
                                otherProject = workspace.getRoot().getProject(projectPath.segment(0));
                                otherJavaProject = JavaCore.create((IProject)otherProject);
                                urls.add(new File(otherProject.getLocation() + "/" + otherJavaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
                            }
                            ++var13_19;
                        }
                        theClassLoader /* !! */  = new URLClassLoader(urls.toArray(new URL[0])){

                            @Override
                            public Class<?> loadClass(String className) throws ClassNotFoundException {
                                try {
                                    return super.loadClass(className);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    return jetEmitter.classLoader.loadClass(className);
                                }
                            }
                        };
                    }
                } else if (templateURI.isPlatformPlugin() && (bundle = Platform.getBundle((String)templateURI.segment(1))) != null) {
                    theClassLoader /* !! */  = new URLClassLoader(new URL[0], jetEmitter.classLoader){

                        @Override
                        public Class<?> loadClass(String className) throws ClassNotFoundException {
                            try {
                                return bundle.loadClass(className);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                return super.loadClass(className);
                            }
                        }
                    };
                }
                if (theClassLoader /* !! */  == null) ** GOTO lbl-1000
                className = String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + jetCompiler.getSkeleton().getClassName();
                if (className.endsWith("_")) {
                    className = className.substring(0, className.length() - 1);
                }
                try {
                    theClass = theClassLoader /* !! */ .loadClass(className);
                    theOtherClass = null;
                    try {
                        theOtherClass = jetEmitter.classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException classpathEntry) {
                        // empty catch block
                    }
                    if (theClass != theOtherClass) {
                        methodName = jetCompiler.getSkeleton().getMethodName();
                        methods = theClass.getDeclaredMethods();
                        i = 0;
                        while (i < methods.length) {
                            if (methods[i].getName().equals(methodName)) {
                                jetEmitter.setMethod(methods[i]);
                                break;
                            }
                            ++i;
                        }
                        return;
                    }
                    ** GOTO lbl-1000
                }
                catch (ClassNotFoundException theClass) {
                    try lbl-1000:
                    // 4 sources

                    {
                        outputStream = new ByteArrayOutputStream();
                        jetCompiler.generate(outputStream);
                        contents = new ByteArrayInputStream(outputStream.toByteArray());
                        if (!javaModel.isOpen()) {
                            javaModel.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        } else {
                            progressMonitor.worked(1);
                        }
                        project = workspace.getRoot().getProject(jetEmitter.getProjectName());
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETPreparingProject_message", new Object[]{project.getName()}));
                        if (!project.exists()) {
                            progressMonitor.subTask("JET creating project " + project.getName());
                            project.create((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreatingProject_message", new Object[]{project.getName()}));
                            description = workspace.newProjectDescription(project.getName());
                            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                            description.setLocation(null);
                            project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            javaProject = JavaCore.create((IProject)project);
                            for (Map.Entry<String, String> option : jetEmitter.getJavaOptions().entrySet()) {
                                javaProject.setOption(option.getKey(), option.getValue());
                            }
                        } else {
                            project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                            description = project.getDescription();
                            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            javaProject = JavaCore.create((IProject)project);
                        }
                        classpath = new UniqueEList(Arrays.asList(javaProject.getRawClasspath()));
                        i = 0;
                        len = classpath.size();
                        while (i < len) {
                            entry = (IClasspathEntry)classpath.get(i);
                            if (entry.getEntryKind() == 3 && ("/" + project.getName()).equals(entry.getPath().toString())) {
                                classpath.remove(i);
                            }
                            ++i;
                        }
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETInitializingProject_message", new Object[]{project.getName()}));
                        classpathEntry = JavaCore.newSourceEntry((IPath)new Path("/" + project.getName() + "/src"));
                        jreClasspathEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
                        classpath.add(classpathEntry);
                        classpath.add(jreClasspathEntry);
                        classpath.addAll(jetEmitter.classpathEntries);
                        sourceFolder = project.getFolder((IPath)new Path("src"));
                        if (!sourceFolder.exists()) {
                            sourceFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        }
                        if (!(runtimeFolder = project.getFolder((IPath)new Path("bin"))).exists()) {
                            runtimeFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        }
                        javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        javaProject.setOutputLocation((IPath)new Path("/" + project.getName() + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        javaProject.close();
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETOpeningJavaProject_message", new Object[]{project.getName()}));
                        javaProject.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        packageFragmentRoots = javaProject.getPackageFragmentRoots();
                        sourcePackageFragmentRoot = null;
                        j = 0;
                        while (j < packageFragmentRoots.length) {
                            packageFragmentRoot = packageFragmentRoots[j];
                            if (packageFragmentRoot.getKind() == 1) {
                                sourcePackageFragmentRoot = packageFragmentRoot;
                                break;
                            }
                            ++j;
                        }
                        stringTokenizer = new StringTokenizer(packageName, ".");
                        subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
                        subProgressMonitor.beginTask("", stringTokenizer.countTokens() + 4);
                        subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_CreateTargetFile_message"));
                        sourceContainer = sourcePackageFragmentRoot == null ? project : (IContainer)sourcePackageFragmentRoot.getCorrespondingResource();
                        while (stringTokenizer.hasMoreElements()) {
                            folderName = stringTokenizer.nextToken();
                            if ((sourceContainer = sourceContainer.getFolder((IPath)new Path(folderName))).exists()) continue;
                            ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        }
                        targetFile = sourceContainer.getFile((IPath)new Path(String.valueOf(jetCompiler.getSkeleton().getClassName()) + ".java"));
                        if (!targetFile.exists()) {
                            subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreating_message", new Object[]{targetFile.getFullPath()}));
                            targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        } else {
                            subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdating_message", new Object[]{targetFile.getFullPath()}));
                            targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        }
                        subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETBuilding_message", new Object[]{project.getName()}));
                        project.build(10, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        markers = targetFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        errors = false;
                        i = 0;
                        while (i < markers.length) {
                            marker = markers[i];
                            if (marker.getAttribute("severity", 0) == 2) {
                                errors = true;
                                subProgressMonitor.subTask(marker.getAttribute("message") + " : " + CodeGenPlugin.getPlugin().getString("jet.mark.file.line", new Object[]{targetFile.getLocation(), marker.getAttribute("lineNumber")}));
                            }
                            ++i;
                        }
                        if (!errors) {
                            subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETLoadingClass_message", new Object[]{String.valueOf(jetCompiler.getSkeleton().getClassName()) + ".class"}));
                            urls = new ArrayList<URL>();
                            urls.add(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
                            bundles = new HashSet<Bundle>();
                            block18: for (IClasspathEntry jetEmitterClasspathEntry : jetEmitter.getClasspathEntries()) {
                                classpathAttributes = jetEmitterClasspathEntry.getExtraAttributes();
                                if (classpathAttributes != null) {
                                    var32_47 = classpathAttributes;
                                    var31_46 = classpathAttributes.length;
                                    var30_45 = 0;
                                    while (var30_45 < var31_46) {
                                        classpathAttribute = var32_47[var30_45];
                                        if (classpathAttribute.getName().equals("plugin_id") && (bundle = Platform.getBundle((String)classpathAttribute.getValue())) != null) {
                                            bundles.add(bundle);
                                            continue block18;
                                        }
                                        ++var30_45;
                                    }
                                }
                                urls.add(new URL("platform:/resource" + jetEmitterClasspathEntry.getPath() + "/"));
                            }
                            theClassLoader = new URLClassLoader(urls.toArray(new URL[0]), jetEmitter.classLoader){

                                /*
                                 * Unable to fully structure code
                                 */
                                @Override
                                public Class<?> loadClass(String className) throws ClassNotFoundException {
                                    try {
                                        return super.loadClass(className);
                                    }
                                    catch (ClassNotFoundException exception) {
                                        ** for (bundle : bundles)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        try {
                                            return bundle.loadClass(className);
                                        }
                                        catch (ClassNotFoundException var5_5) {
                                            // empty catch block
                                        }
                                        continue;
                                    }
lbl10:
                                    // 1 sources

                                    throw exception;
                                }
                            };
                            theClass = theClassLoader.loadClass(String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + jetCompiler.getSkeleton().getClassName());
                            methodName = jetCompiler.getSkeleton().getMethodName();
                            methods = theClass.getDeclaredMethods();
                            i = 0;
                            while (i < methods.length) {
                                if (methods[i].getName().equals(methodName)) {
                                    jetEmitter.setMethod(methods[i]);
                                    break;
                                }
                                ++i;
                            }
                        }
                        subProgressMonitor.done();
                    }
                    catch (CoreException exception) {
                        throw new JETException(exception);
                    }
                    catch (Exception exception) {
                        throw new JETException(exception);
                    }
                }
            }
            finally {
                progressMonitor.done();
            }
        }

        public static void addVariable(JETEmitter jetEmitter, String variableName, String pluginID) throws JETException {
            URL classpathURL;
            Bundle bundle = Platform.getBundle((String)pluginID);
            URL uRL = classpathURL = bundle != null && Platform.inDevelopmentMode() ? bundle.getEntry(".classpath") : null;
            if (bundle == null) {
                try {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginID);
                    if (project != null) {
                        classpathURL = new File(project.getLocation() + "/.classpath").toURI().toURL();
                    }
                }
                catch (MalformedURLException exception) {
                    throw new JETException(exception);
                }
            }
            boolean addClasspathEntries = true;
            if (classpathURL != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                try {
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource(classpathURL.toString()));
                    Node child = document.getDocumentElement().getFirstChild();
                    while (child != null) {
                        Element classpathEntryElement;
                        if (child.getNodeType() == 1 && "classpathentry".equals((classpathEntryElement = (Element)child).getNodeName()) && "output".equals(classpathEntryElement.getAttribute("kind"))) {
                            IClasspathAttribute[] iClasspathAttributeArray;
                            IFolder folder;
                            URI uri = URI.createURI((String)classpathEntryElement.getAttribute("path")).resolve(URI.createURI((String)classpathURL.toString()));
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IProject project = workspace.getRoot().getProject(jetEmitter.getProjectName());
                            if (!project.exists()) {
                                project.create((IProgressMonitor)new NullProgressMonitor());
                            }
                            if (!project.isOpen()) {
                                project.open((IProgressMonitor)new NullProgressMonitor());
                            }
                            if (!(folder = project.getFolder("." + pluginID)).exists()) {
                                folder.createLink(new Path(CommonPlugin.asLocalURI((URI)uri).toFileString()).removeTrailingSeparator(), 16, (IProgressMonitor)new NullProgressMonitor());
                            }
                            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            IPath path = folder.getFullPath();
                            if (bundle == null) {
                                iClasspathAttributeArray = new IClasspathAttribute[]{};
                            } else {
                                IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                                iClasspathAttributeArray = iClasspathAttributeArray2;
                                iClasspathAttributeArray2[0] = JavaCore.newClasspathAttribute((String)"plugin_id", (String)pluginID);
                            }
                            IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)path, null, null, null, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)true);
                            jetEmitter.getClasspathEntries().add(newLibraryEntry);
                            addClasspathEntries = false;
                            break;
                        }
                        child = child.getNextSibling();
                    }
                }
                catch (Exception exception) {
                    CodeGenPlugin.INSTANCE.log(exception);
                }
            }
            if (addClasspathEntries) {
                CodeGenUtil.EclipseUtil.addClasspathEntries(jetEmitter.getClasspathEntries(), variableName, pluginID);
            }
        }
    }

    protected static class MyBaseJETCompiler
    extends JETCompiler {
        protected ClassLoader classLoader;

        public MyBaseJETCompiler(String templateURI, ClassLoader classLoader) throws JETException {
            super(templateURI);
            this.classLoader = classLoader;
        }

        public MyBaseJETCompiler(String templateURI, String encoding, ClassLoader classLoader) throws JETException {
            super(templateURI, encoding);
            this.classLoader = classLoader;
        }

        public MyBaseJETCompiler(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader) throws JETException {
            super(templateURIPath, relativeTemplateURI);
            this.classLoader = classLoader;
        }

        public MyBaseJETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding, ClassLoader classLoader) throws JETException {
            super(templateURIPath, relativeTemplateURI, encoding);
            this.classLoader = classLoader;
        }

        protected void handleNewSkeleton() {
            String packageName = this.skeleton.getPackageName();
            String skeletonClassName = this.skeleton.getClassName();
            String qualifiedSkeletonClassName = String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + skeletonClassName;
            if (this.classLoader != null) {
                try {
                    Class<?> theClass = this.classLoader.loadClass(qualifiedSkeletonClassName);
                    if (theClass != null) {
                        skeletonClassName = String.valueOf(skeletonClassName) + "_";
                        this.skeleton.setClassName(skeletonClassName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected class MyJETCompiler
    extends MyBaseJETCompiler {
        public MyJETCompiler(String templateURI) throws JETException {
            super(templateURI, JETEmitter.this.classLoader);
        }

        public MyJETCompiler(String templateURI, String encoding) throws JETException {
            super(templateURI, encoding, JETEmitter.this.classLoader);
        }

        public MyJETCompiler(String[] templateURIPath, String relativeTemplateURI) throws JETException {
            super(templateURIPath, relativeTemplateURI, JETEmitter.this.classLoader);
        }

        public MyJETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding) throws JETException {
            super(templateURIPath, relativeTemplateURI, encoding, JETEmitter.this.classLoader);
        }
    }
}

