/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.validation.oclpivot;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.uml.internal.validation.UMLOCLEValidator;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOCLpivotModelConstraint
implements IModelConstraint {
    private final IConstraintDescriptor descriptor;
    protected static Map<ResourceSet, WeakOCLReference> oclRefMap = null;

    public AbstractOCLpivotModelConstraint(IConstraintDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected synchronized OCLAndQueries getOCL(EObject element) {
        WeakOCLReference oclRef;
        ResourceSet rs = element.eResource().getResourceSet();
        if (oclRefMap == null) {
            oclRefMap = new HashMap<ResourceSet, WeakOCLReference>();
        }
        if ((oclRef = oclRefMap.get(rs)) == null || oclRef.get() == null) {
            oclRef = new WeakOCLReference(new OCLAndQueries());
            oclRefMap.put(rs, oclRef);
        }
        return (OCLAndQueries)oclRef.get();
    }

    public ExpressionInOCL getConstraintCondition(EObject target, OCL ocl, Map<IModelConstraint, ExpressionInOCL> queries) {
        Stereotype umlStereotype = UMLUtil.getStereotype((EObject)target);
        if (umlStereotype == null) {
            return null;
        }
        ExpressionInOCL result = queries.get(this);
        if (result == null) {
            try {
                Class context = (Class)ocl.getMetamodelManager().getASOf(Class.class, (EObject)umlStereotype);
                String expression = this.getDescriptor().getBody();
                result = ocl.createQuery((EObject)context, expression);
            }
            catch (ParserException parserException) {
                throw new WrappedException((Exception)((Object)parserException));
            }
            queries.put(this, result);
        }
        return result;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        try {
            OCLAndQueries oclAndQueries = this.getOCL(target);
            ExpressionInOCL query = this.getConstraintCondition(target, oclAndQueries.ocl, oclAndQueries.queries);
            UMLOCLEValidator.ConstraintEvaluatorWithoutDiagnostics constraintEvaluator = new UMLOCLEValidator.ConstraintEvaluatorWithoutDiagnostics(query);
            EvaluationVisitor evaluationVisitor = oclAndQueries.ocl.createEvaluationVisitor((Object)target, query);
            if (((Boolean)constraintEvaluator.evaluate(evaluationVisitor)).booleanValue()) {
                return ctx.createSuccessStatus();
            }
            return ctx.createFailureStatus(new Object[]{target});
        }
        catch (Exception e) {
            String message = String.format("The '%s' constraint is invalid - %s", this.getDescriptor().getName(), e.getMessage());
            return new ConstraintStatus((IModelConstraint)this, target, 4, -1, message, null);
        }
    }

    public IConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected static final class OCLAndQueries {
        OCL ocl = OCL.newInstance();
        Map<IModelConstraint, ExpressionInOCL> queries = new HashMap<IModelConstraint, ExpressionInOCL>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class WeakOCLReference
    extends WeakReference<OCLAndQueries> {
        OCLAndQueries oclCopy;

        protected WeakOCLReference(OCLAndQueries ocl) {
            super(ocl);
            this.oclCopy = ocl;
        }

        public void finalize() {
            new Thread("OCLandQueries-Finalizer"){

                public void run() {
                    if (WeakOCLReference.this.oclCopy.queries != null) {
                        WeakOCLReference.this.oclCopy.queries.clear();
                    }
                    WeakOCLReference.this.oclCopy.ocl.dispose();
                }
            }.start();
        }
    }
}

