/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.discovery.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.infra.discovery.Category;
import org.eclipse.papyrus.infra.discovery.DiscoveryDefinition;
import org.eclipse.papyrus.infra.discovery.DiscoveryFactory;
import org.eclipse.papyrus.infra.discovery.DiscoveryPackage;
import org.eclipse.papyrus.infra.discovery.Group;
import org.eclipse.papyrus.infra.discovery.InstallableComponent;
import org.eclipse.papyrus.infra.discovery.Message;
import org.eclipse.papyrus.infra.discovery.Overview;
import org.eclipse.papyrus.infra.discovery.Severity;
import org.eclipse.papyrus.infra.discovery.impl.CategoryImpl;
import org.eclipse.papyrus.infra.discovery.impl.DiscoveryDefinitionImpl;
import org.eclipse.papyrus.infra.discovery.impl.GroupImpl;
import org.eclipse.papyrus.infra.discovery.impl.InstallableComponentImpl;
import org.eclipse.papyrus.infra.discovery.impl.MessageImpl;
import org.eclipse.papyrus.infra.discovery.impl.OverviewImpl;

public class DiscoveryFactoryImpl
extends EFactoryImpl
implements DiscoveryFactory {
    public static DiscoveryFactory init() {
        try {
            DiscoveryFactory theDiscoveryFactory = (DiscoveryFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/discovery/1.0");
            if (theDiscoveryFactory != null) {
                return theDiscoveryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DiscoveryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createInstallableComponent();
            }
            case 1: {
                return this.createOverview();
            }
            case 2: {
                return this.createCategory();
            }
            case 3: {
                return this.createDiscoveryDefinition();
            }
            case 4: {
                return this.createGroup();
            }
            case 5: {
                return this.createMessage();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createSeverityFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertSeverityToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public InstallableComponent createInstallableComponent() {
        InstallableComponentImpl installableComponent = new InstallableComponentImpl();
        return installableComponent;
    }

    public Overview createOverview() {
        OverviewImpl overview = new OverviewImpl();
        return overview;
    }

    public Category createCategory() {
        CategoryImpl category = new CategoryImpl();
        return category;
    }

    public DiscoveryDefinition createDiscoveryDefinition() {
        DiscoveryDefinitionImpl discoveryDefinition = new DiscoveryDefinitionImpl();
        return discoveryDefinition;
    }

    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    public Message createMessage() {
        MessageImpl message = new MessageImpl();
        return message;
    }

    public Severity createSeverityFromString(EDataType eDataType, String initialValue) {
        Severity result = Severity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DiscoveryPackage getDiscoveryPackage() {
        return (DiscoveryPackage)this.getEPackage();
    }

    @Deprecated
    public static DiscoveryPackage getPackage() {
        return DiscoveryPackage.eINSTANCE;
    }
}

