/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.state.xtext.ui.contributions;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.textedit.state.xtext.ui.contentassist.UmlStateProposalProvider;
import org.eclipse.papyrus.uml.textedit.state.xtext.ui.internal.UmlStateActivator;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.BehaviorKind;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.StateRule;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;

public class StateEditorConfigurationContribution
extends DefaultXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    private static final String EMPTY = "";
    private static final String ACTIVITY = "Activity";
    private StateMachine newSubmachine = null;
    private String newStateName;
    private String newEntryName = null;
    private BehaviorKind newEntryKind;
    private String newDoName = null;
    private BehaviorKind newDoKind;
    private String newExitName = null;
    private BehaviorKind newExitKind;

    public int getStyle() {
        return 2;
    }

    public Injector getInjector() {
        return UmlStateActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.state.xtext.UmlState");
    }

    /*
     * Unable to fully structure code
     */
    protected ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        state = (State)modelObject;
        modifiedObject = xtextObject;
        if (modelObject instanceof State) ** GOTO lbl6
        return UnexecutableCommand.INSTANCE;
lbl-1000:
        // 1 sources

        {
            modifiedObject = modifiedObject.eContainer();
lbl6:
            // 2 sources

            ** while (xtextObject != null && !(xtextObject instanceof StateRule))
        }
lbl7:
        // 1 sources

        if (modifiedObject == null) {
            return UnexecutableCommand.INSTANCE;
        }
        stateRuleObject = (StateRule)xtextObject;
        this.newStateName = stateRuleObject.getName();
        this.newSubmachine = null;
        this.newEntryName = "";
        this.newDoName = "";
        this.newExitName = "";
        if (stateRuleObject.getSubmachine() != null) {
            this.newSubmachine = stateRuleObject.getSubmachine().getSubmachine();
        }
        if (stateRuleObject.getEntry() != null) {
            this.newEntryKind = stateRuleObject.getEntry().getKind();
            if (stateRuleObject.getEntry().getBehaviorName() != null) {
                this.newEntryName = stateRuleObject.getEntry().getBehaviorName();
            }
        }
        if (stateRuleObject.getDo() != null) {
            this.newDoKind = stateRuleObject.getDo().getKind();
            if (stateRuleObject.getDo().getBehaviorName() != null) {
                this.newDoName = stateRuleObject.getDo().getBehaviorName();
            }
        }
        if (stateRuleObject.getExit() != null) {
            this.newExitKind = stateRuleObject.getExit().getKind();
            if (stateRuleObject.getExit().getBehaviorName() != null) {
                this.newExitName = stateRuleObject.getExit().getBehaviorName();
            }
        }
        return new UpdateUMLStateCommand(state);
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof State) {
            String kind;
            State state = (State)editedObject;
            String textToEdit = EMPTY;
            textToEdit = String.valueOf(textToEdit) + state.getName();
            if (state.isSubmachineState()) {
                textToEdit = String.valueOf(textToEdit) + " : " + UmlStateProposalProvider.getSubmachineLabel(state.getSubmachine());
            }
            if (state.getEntry() != null) {
                kind = this.behaviorKindAsString(state.getEntry());
                textToEdit = String.valueOf(textToEdit) + "\nentry " + kind + " " + state.getEntry().getName();
            }
            if (state.getDoActivity() != null) {
                kind = this.behaviorKindAsString(state.getDoActivity());
                textToEdit = String.valueOf(textToEdit) + "\ndo " + kind + " " + state.getDoActivity().getName();
            }
            if (state.getExit() != null) {
                kind = this.behaviorKindAsString(state.getExit());
                textToEdit = String.valueOf(textToEdit) + "\nexit " + kind + " " + state.getExit().getName();
            }
            return textToEdit;
        }
        return "not a State";
    }

    static TransactionalEditingDomain getEditingDomain(EObject context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    private String behaviorKindAsString(Behavior b) {
        if (b instanceof Activity) {
            return ACTIVITY;
        }
        if (b instanceof StateMachine) {
            return "StateMachine";
        }
        if (b instanceof OpaqueBehavior) {
            return "OpaqueBehavior";
        }
        return EMPTY;
    }

    private BehaviorKind behaviorKindAsBehaviorKind(Behavior b) {
        if (b instanceof Activity) {
            return BehaviorKind.ACTIVITY;
        }
        if (b instanceof StateMachine) {
            return BehaviorKind.STATE_MACHINE;
        }
        if (b instanceof OpaqueBehavior) {
            return BehaviorKind.OPAQUE_BEHAVIOR;
        }
        return BehaviorKind.OPAQUE_BEHAVIOR;
    }

    private Behavior createBehavior(BehaviorKind kind, String name) {
        if (kind == null) {
            return null;
        }
        Activity behavior = null;
        switch (kind) {
            case ACTIVITY: {
                behavior = UMLFactory.eINSTANCE.createActivity();
                break;
            }
            case OPAQUE_BEHAVIOR: {
                behavior = UMLFactory.eINSTANCE.createOpaqueBehavior();
                break;
            }
            case STATE_MACHINE: {
                behavior = UMLFactory.eINSTANCE.createStateMachine();
                break;
            }
        }
        behavior.setName(name);
        return behavior;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BehaviorRole_Local {
        ENTRY,
        DO,
        EXIT;

    }

    protected class UpdateUMLStateCommand
    extends AbstractTransactionalCommand {
        private static final String STATE_UPDATE_CMD = "State Update";
        private State state;

        public UpdateUMLStateCommand(State state) {
            super(StateEditorConfigurationContribution.getEditingDomain((EObject)state), STATE_UPDATE_CMD, UpdateUMLStateCommand.getWorkspaceFiles((EObject)state));
            this.state = state;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.state.setName(StateEditorConfigurationContribution.this.newStateName);
            this.state.setSubmachine(StateEditorConfigurationContribution.this.newSubmachine);
            this.state.setEntry(this.updateOrCreateBehavior(BehaviorRole_Local.ENTRY, StateEditorConfigurationContribution.this.newEntryKind, StateEditorConfigurationContribution.this.newEntryName));
            this.state.setDoActivity(this.updateOrCreateBehavior(BehaviorRole_Local.DO, StateEditorConfigurationContribution.this.newDoKind, StateEditorConfigurationContribution.this.newDoName));
            this.state.setExit(this.updateOrCreateBehavior(BehaviorRole_Local.EXIT, StateEditorConfigurationContribution.this.newExitKind, StateEditorConfigurationContribution.this.newExitName));
            return CommandResult.newOKCommandResult((Object)this.state);
        }

        private Behavior updateOrCreateBehavior(BehaviorRole_Local role, BehaviorKind kind, String behaviorName) {
            Behavior behavior = null;
            switch (role) {
                case DO: {
                    behavior = this.state.getDoActivity();
                    if (behavior != null) {
                        if (behaviorName.equals(StateEditorConfigurationContribution.EMPTY)) {
                            this.state.setDoActivity(null);
                            behavior.destroy();
                            behavior = null;
                            break;
                        }
                        if (StateEditorConfigurationContribution.this.behaviorKindAsBehaviorKind(behavior) != kind) {
                            this.state.setDoActivity(null);
                            behavior.destroy();
                            behavior = StateEditorConfigurationContribution.this.createBehavior(kind, behaviorName);
                            break;
                        }
                        behavior.setName(behaviorName);
                        break;
                    }
                    if (behaviorName.equals(StateEditorConfigurationContribution.EMPTY)) break;
                    behavior = StateEditorConfigurationContribution.this.createBehavior(kind, behaviorName);
                    break;
                }
                case ENTRY: {
                    behavior = this.state.getEntry();
                    if (behavior != null) {
                        if (behaviorName.equals(StateEditorConfigurationContribution.EMPTY)) {
                            this.state.setEntry(null);
                            behavior.destroy();
                            behavior = null;
                            break;
                        }
                        if (StateEditorConfigurationContribution.this.behaviorKindAsBehaviorKind(behavior) != kind) {
                            this.state.setEntry(null);
                            behavior.destroy();
                            behavior = StateEditorConfigurationContribution.this.createBehavior(kind, behaviorName);
                            break;
                        }
                        behavior.setName(behaviorName);
                        break;
                    }
                    if (behaviorName.equals(StateEditorConfigurationContribution.EMPTY)) break;
                    behavior = StateEditorConfigurationContribution.this.createBehavior(kind, behaviorName);
                    break;
                }
                case EXIT: {
                    behavior = this.state.getExit();
                    if (behavior != null) {
                        if (behaviorName.equals(StateEditorConfigurationContribution.EMPTY)) {
                            this.state.setExit(null);
                            behavior.destroy();
                            behavior = null;
                            break;
                        }
                        if (StateEditorConfigurationContribution.this.behaviorKindAsBehaviorKind(behavior) != kind) {
                            this.state.setExit(null);
                            behavior.destroy();
                            behavior = StateEditorConfigurationContribution.this.createBehavior(kind, behaviorName);
                            break;
                        }
                        behavior.setName(behaviorName);
                        break;
                    }
                    if (behaviorName.equals(StateEditorConfigurationContribution.EMPTY)) break;
                    behavior = StateEditorConfigurationContribution.this.createBehavior(kind, behaviorName);
                    break;
                }
            }
            return behavior;
        }
    }
}

