/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.uml.diagram.common.draw2d.anchors.LifelineAnchor;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomInteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message4EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class LifelineMessageCreateHelper {
    public static ConnectionAnchor getCreateMessageAnchor(LifelineEditPart part, Request request, Point location) {
        RectangleFigure fig = part.getPrimaryShape().getFigureLifelineNameContainerFigure();
        fig.translateToRelative((Translatable)location);
        if (fig.containsPoint(location)) {
            return new LifelineAnchor((IFigure)part.getPrimaryShape().getFigureLifelineNameContainerFigure());
        }
        return LifelineMessageCreateHelper.getTargetConnectionAnchor(part, request);
    }

    static ConnectionAnchor getTargetConnectionAnchor(LifelineEditPart part, Request request) {
        NodeFigure nodeFigure = null;
        if (part instanceof CustomLifelineEditPart) {
            nodeFigure = ((CustomLifelineEditPart)part).getNodeFigure();
        } else if (part.getContentPane() instanceof LifelineDotLineCustomFigure) {
            nodeFigure = ((LifelineDotLineCustomFigure)part.getContentPane()).getDashLineRectangle();
        }
        if (nodeFigure == null) {
            return null;
        }
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return nodeFigure.getTargetConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return nodeFigure.getTargetConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return nodeFigure.getTargetConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return nodeFigure.getTargetConnectionAnchorAt(null);
    }

    public static Command restoreLifelineOnMessageDelete(Command commands, EditPart editPart) {
        ShapeImpl view;
        LifelineEditPart target;
        Message4EditPart part;
        if (editPart instanceof Message4EditPart && (part = (Message4EditPart)editPart).getTarget() instanceof LifelineEditPart && LifelineMessageCreateHelper.getIncomingMessageCreate(part.getTarget()).size() == 1 && (target = (LifelineEditPart)part.getTarget()).getModel() instanceof Shape && (view = (ShapeImpl)target.getModel()).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)view.getLayoutConstraint();
            SetBoundsCommand boundsCommand = new SetBoundsCommand(target.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)view), new Point(bounds.getX(), 10));
            commands = commands.chain((Command)new ICommandProxy((ICommand)boundsCommand));
            int dy = 10 - bounds.getY();
            commands = LifelineMessageCreateHelper.moveCascadeLifeline(target, commands, dy);
        }
        return commands;
    }

    public static Command restoreLifelineOnDelete(Command command, LifelineEditPart part) {
        List list = part.getSourceConnections();
        if (list != null && list.size() > 0) {
            for (Object l : list) {
                EditPart target;
                if (!(l instanceof Message4EditPart) || !((target = ((Message4EditPart)((Object)l)).getTarget()) instanceof LifelineEditPart) || LifelineMessageCreateHelper.getIncomingMessageCreate(target).size() != 1) continue;
                LifelineEditPart lp = (LifelineEditPart)target;
                Rectangle bounds = lp.getPrimaryShape().getBounds();
                Point location = new Point(bounds.x, 10);
                int dy = location.y - bounds.y;
                SetBoundsCommand boundsCommand = new SetBoundsCommand(lp.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)lp.getNotationView()), location);
                command = command.chain((Command)new ICommandProxy((ICommand)boundsCommand));
                command = LifelineMessageCreateHelper.moveCascadeLifeline(lp, command, dy);
            }
        }
        return command;
    }

    public static boolean hasMessageCreate(GraphicalEditPart sourceEditPart, EditPart targetEditPart) {
        List list = sourceEditPart.getSourceConnections();
        for (Object o : list) {
            if (!(o instanceof Message4EditPart) || !targetEditPart.equals(((Message4EditPart)((Object)o)).getTarget())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIncomingMessageCreate(EditPart target) {
        return LifelineMessageCreateHelper.getIncomingMessageCreate(target).size() > 0;
    }

    public static List<?> getIncomingMessageCreate(EditPart target) {
        List list;
        ArrayList<Message4EditPart> create = new ArrayList<Message4EditPart>();
        if (target instanceof LifelineEditPart && (list = ((LifelineEditPart)target).getTargetConnections()) != null && list.size() > 0) {
            for (Object l : list) {
                if (!(l instanceof Message4EditPart)) continue;
                create.add((Message4EditPart)((Object)l));
            }
        }
        return create;
    }

    public static boolean canReconnectMessageCreate(ReconnectRequest request) {
        Message4EditPart connPart = (Message4EditPart)request.getConnectionEditPart();
        return !(request.isMovingStartAnchor() ? LifelineMessageCreateHelper.hasMessageCreate((GraphicalEditPart)request.getTarget(), (EditPart)((GraphicalEditPart)connPart.getTarget())) : LifelineMessageCreateHelper.hasMessageCreate((GraphicalEditPart)connPart.getSource(), request.getTarget()));
    }

    public static Command reconnectMessageCreateTarget(ReconnectRequest request, Command command) {
        LifelineEditPart oldTarget = (LifelineEditPart)request.getConnectionEditPart().getTarget();
        CustomLifelineEditPart newTarget = (CustomLifelineEditPart)request.getTarget();
        if (LifelineMessageCreateHelper.getIncomingMessageCreate((EditPart)oldTarget).size() == 1) {
            Rectangle bounds = oldTarget.getPrimaryShape().getBounds();
            Point location = new Point(bounds.x, 10);
            int dy = location.y - bounds.y;
            SetBoundsCommand boundsCommand = new SetBoundsCommand(oldTarget.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)oldTarget.getNotationView()), location);
            command = command.chain((Command)new ICommandProxy((ICommand)boundsCommand));
            command = LifelineMessageCreateHelper.moveCascadeLifeline(oldTarget, command, dy);
        }
        command = LifelineMessageCreateHelper.moveLifelineDown(command, newTarget, request.getLocation().getCopy());
        return command;
    }

    public static Command moveLifelineDown(Command command, CustomLifelineEditPart part, Point sourcePointCopy) {
        IFigure fig = part.getFigure();
        Rectangle bounds = fig.getBounds().getCopy();
        int height = part.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().height;
        if (bounds.isEmpty()) {
            bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)part);
            height = 29;
        } else {
            fig.translateToAbsolute((Translatable)bounds);
        }
        Point location = new Point(bounds.x, Math.max(bounds.y, sourcePointCopy.y() - height / 2));
        View targetView = part.getNotationView();
        if (location.y != bounds.y) {
            int dy = location.y - bounds.y;
            fig.translateToRelative((Translatable)location);
            fig.translateToParent((Translatable)location);
            SetBoundsCommand boundsCommand = new SetBoundsCommand(part.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)targetView), location);
            command = command.chain((Command)new ICommandProxy((ICommand)boundsCommand));
            command = LifelineMessageCreateHelper.moveCascadeLifeline(part, command, dy);
        }
        return command;
    }

    public static Command moveCascadeLifeline(LifelineEditPart part, Command command, int dy) {
        command = LifelineMessageCreateHelper.moveCascadeLifelineRecursive(part, command, dy);
        CustomInteractionEditPart interactionEP = (CustomInteractionEditPart)part.getParent().getParent();
        command = interactionEP.getUpdateLifelinesHeightsCommand(command);
        return command;
    }

    public static Command moveCascadeLifelineRecursive(LifelineEditPart part, Command command, int dy) {
        List list = part.getSourceConnections();
        if (list != null && list.size() > 0) {
            for (Object l : list) {
                EditPart target;
                if (!(l instanceof Message4EditPart) || !((target = ((Message4EditPart)((Object)l)).getTarget()) instanceof CustomLifelineEditPart)) continue;
                CustomLifelineEditPart lp = (CustomLifelineEditPart)target;
                Rectangle bounds = lp.getFigure().getBounds().getCopy();
                View targetView = lp.getNotationView();
                Point location = bounds.getLocation().getCopy().translate(0, dy);
                ICommandProxy boundsCommand = new ICommandProxy((ICommand)new SetBoundsCommand(part.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)targetView), location));
                if (dy < 0) {
                    command = command == null ? boundsCommand : command.chain((Command)boundsCommand);
                    command = LifelineMessageCreateHelper.moveCascadeLifelineRecursive(lp, command, dy);
                    continue;
                }
                Object object = command = (command = LifelineMessageCreateHelper.moveCascadeLifelineRecursive(lp, command, dy)) == null ? boundsCommand : command.chain((Command)boundsCommand);
            }
        }
        return command;
    }

    public static boolean canMoveLifelineVertical(LifelineEditPart child, Rectangle newBounds) {
        int halfHeight = child.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().height / 2;
        List list = child.getSourceConnections();
        if (list != null && list.size() > 0) {
            for (Object l : list) {
                if (!(l instanceof Message4EditPart) || !(((Message4EditPart)((Object)l)).getTarget() instanceof LifelineEditPart)) continue;
                LifelineEditPart lowPart = (LifelineEditPart)((Message4EditPart)((Object)l)).getTarget();
                Rectangle outBounds = lowPart.getFigure().getBounds();
                if (outBounds.y - newBounds.y >= halfHeight) continue;
                return false;
            }
        }
        if ((list = child.getTargetConnections()) != null && list.size() > 0) {
            for (Object l : list) {
                if (!(l instanceof Message4EditPart) || !(((Message4EditPart)((Object)l)).getSource() instanceof LifelineEditPart)) continue;
                LifelineEditPart highPart = (LifelineEditPart)((Message4EditPart)((Object)l)).getSource();
                Rectangle inBounds = highPart.getFigure().getBounds();
                if (newBounds.y - inBounds.y < halfHeight) {
                    return false;
                }
                if (newBounds.y <= inBounds.getBottom().y - halfHeight) continue;
                return false;
            }
        }
        return true;
    }

    public static class ComponentEditPolicyEx
    extends ComponentEditPolicy {
        protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
            Command command = super.createDeleteViewCommand(deleteRequest);
            if (command != null && this.getHost() instanceof LifelineEditPart) {
                command = LifelineMessageCreateHelper.restoreLifelineOnDelete(command, (LifelineEditPart)this.getHost());
            }
            return command;
        }
    }
}

