/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.discovery.ui.internal.common;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.discovery.InstallableComponent;
import org.eclipse.papyrus.infra.discovery.ui.Activator;
import org.eclipse.papyrus.infra.discovery.ui.internal.common.DiscoveryUiUtil;
import org.eclipse.papyrus.infra.discovery.ui.internal.common.PrepareInstallProfileJob;
import org.eclipse.papyrus.infra.discovery.ui.internal.wizards.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer {
    public static boolean install(Collection<InstallableComponent> descriptors, IRunnableContext context) {
        try {
            PrepareInstallProfileJob job = new PrepareInstallProfileJob(descriptors);
            context.run(true, true, (IRunnableWithProgress)job);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.papyrus.infra.discovery.ui", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            Activator.getDefault().getLog().log((IStatus)status);
            DiscoveryUiUtil.displayStatus(DiscoveryUiUtil.getShell(), Messages.ConnectorDiscoveryWizard_cannotInstall, (IStatus)status, true);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

