/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ast.utils;

import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssignStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Attribute;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Event;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NAryLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SelfAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionEffect;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionGuard;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Variable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class AstUtils {
    public static List<ParameterList> retrieveParameterList(ParameterListIterator iterator, EObject o) {
        ArrayList<ParameterList> res = new ArrayList<ParameterList>();
        if (o instanceof ForAllPredicate) {
            res.add(((ForAllPredicate)o).getList());
            return res;
        }
        if (o instanceof ForAllStatement) {
            res.add(((ForAllStatement)o).getList());
            return res;
        }
        if (o.eContainer() != null) {
            return AstUtils.retrieveParameterList(iterator, o.eContainer());
        }
        return null;
    }

    public static boolean isSelfAttribute(FullyQualifiedSymbol o) {
        return o.getCtx().getAtoms().size() == 1 && o.getCtx().getAtoms().get(0) instanceof SelfAtom;
    }

    public static boolean isSelfInstance(FullyQualifiedSymbol o) {
        return o.getCtx().getAtoms().size() == 0 && o.getAtom() instanceof SelfAtom;
    }

    public static boolean isGetter(FullyQualifiedSymbol o, boolean includeRecordField) {
        return (o.getAtom() instanceof Attribute || o.getAtom() instanceof ParameterList) && !AstUtils.isLhS(o);
    }

    public static boolean isLhS(EObject o) {
        return o.eContainer() instanceof AssignStatement && o.eContainingFeature().getName().equals("left");
    }

    public static boolean isSetter(FullyQualifiedSymbol o) {
        return o.getAtom() instanceof Attribute && !o.getCtx().getAtoms().isEmpty() && !(AstUtils.getRootObject(o) instanceof AssignStatement);
    }

    public static EObject getRootObject(EObject o) {
        EObject res = o;
        while (res.eContainer() != null) {
            res = res.eContainer();
        }
        return res;
    }

    public static boolean isParentOf(EObject inputObject, EObject left) {
        if (left.equals(inputObject)) {
            return true;
        }
        if (left.eContainer() != null) {
            return AstUtils.isParentOf(inputObject, left.eContainer());
        }
        return false;
    }

    public static boolean isParentOf(String parentHash, EObject left) {
        if (String.valueOf(left.hashCode()).equals(parentHash)) {
            return true;
        }
        if (left.eContainer() != null) {
            return AstUtils.isParentOf(parentHash, left.eContainer());
        }
        return false;
    }

    public static String toString(ASTElement astElement) {
        if (astElement instanceof ForAllPredicate) {
            return "Predicato ForAll";
        }
        if (astElement instanceof ForAllStatement) {
            return "Statement ForAll";
        }
        if (astElement instanceof ITStatement) {
            return "ITStatement";
        }
        if (astElement instanceof NotLogicOP) {
            return "Operatore Logico Not";
        }
        if (astElement instanceof ParameterList) {
            return "Lista";
        }
        if (astElement instanceof TransitionEffect) {
            return "Effetto";
        }
        if (astElement instanceof TransitionGuard) {
            return "Guardia";
        }
        if (astElement instanceof AndLogicOP) {
            return "NAryLogicOP (AND)";
        }
        if (astElement instanceof OrLogicOP) {
            return "NAryLogicOP (OR)";
        }
        if (astElement instanceof NAryLogicOP) {
            return "NAryLogicOP";
        }
        if (astElement instanceof Event) {
            return "Evento";
        }
        if (astElement instanceof Variable) {
            return "Variabile";
        }
        String astElementStr = astElement.toString();
        astElementStr = astElementStr.substring(0, astElementStr.indexOf("@")).replace("eu.fbk.eclipse.profiles.srfast.ASTElements.impl.", "");
        return astElementStr;
    }
}

