/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;

public class CDOPredicates {
    private CDOPredicates() {
    }

    public static <T> Predicate<T> adaptsTo(Class<?> adapterType) {
        return Predicates.compose((Predicate)Predicates.notNull(), CDOFunctions.adapt(adapterType));
    }

    public static Predicate<CDOResourceNode> hasExtension(String fileExtension) {
        return fileExtension == null ? new HasNoExtension() : new HasExtension(fileExtension);
    }

    public static Predicate<CDOResourceNode> hasURIPrefix(URI prefix) {
        if (!prefix.isPrefix()) {
            throw new IllegalArgumentException("not a URI prefix");
        }
        return new HasURIPrefix(prefix);
    }

    private static final class HasExtension
    implements Predicate<CDOResourceNode> {
        private final String fileExtension;

        HasExtension(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        public boolean apply(CDOResourceNode input) {
            return this.fileExtension.equals(input.getURI().fileExtension());
        }

        public String toString() {
            return String.format("hasExtension(%s)", this.fileExtension);
        }

        public int hashCode() {
            return this.fileExtension.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof HasExtension && ((HasExtension)other).fileExtension.equals(this.fileExtension);
        }
    }

    private static final class HasNoExtension
    implements Predicate<CDOResourceNode> {
        HasNoExtension() {
        }

        public boolean apply(CDOResourceNode input) {
            return input.getURI().fileExtension() == null;
        }

        public String toString() {
            return "hasNoExtension()";
        }

        public int hashCode() {
            return HasNoExtension.class.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof HasNoExtension;
        }
    }

    private static final class HasURIPrefix
    implements Predicate<CDOResourceNode> {
        private final URI prefix;

        HasURIPrefix(URI prefix) {
            this.prefix = prefix;
        }

        public boolean apply(CDOResourceNode input) {
            return input.getURI().toString().startsWith(this.prefix.toString());
        }

        public String toString() {
            return String.format("hasURIPrefix(%s)", this.prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof HasURIPrefix && ((HasURIPrefix)other).prefix.equals(this.prefix);
        }
    }
}

