/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.core.utils;

import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.basetype.baseType.BooleanLiteral;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.Operator;
import eu.fbk.tools.editor.basetype.baseType.RealLiteral;
import eu.fbk.tools.editor.basetype.baseType.util.BaseTypeSwitch;
import eu.fbk.tools.editor.contract.expression.expression.AddSubExpression;
import eu.fbk.tools.editor.contract.expression.expression.Bound;
import eu.fbk.tools.editor.contract.expression.expression.BoundedExpression;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.LogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.MulDivExpression;
import eu.fbk.tools.editor.contract.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.contract.expression.expression.TemporalExpression;
import eu.fbk.tools.editor.contract.expression.expression.UnaryLogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.UnaryTemporalExpression;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.contract.expression.expression.util.ExpressionSwitch;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;

public class OssToSmvExpressionConverter {
    ConverterMapping convMapping;
    String context;
    private BaseTypeConverter baseTypeConverter;

    public static void main(String[] args) throws Exception {
        System.out.println(new OssToSmvExpressionConverter(OutputLanguage.KRATOS).doGenerate("always(a and b)"));
    }

    public OssToSmvExpressionConverter(OutputLanguage outputLanguage, String context) {
        this(outputLanguage);
        this.context = context;
    }

    public OssToSmvExpressionConverter(OutputLanguage outputLanguage) {
        if (outputLanguage.equals((Object)OutputLanguage.KRATOS)) {
            this.convMapping = new KratosConverterMapping();
        } else if (outputLanguage.equals((Object)OutputLanguage.SMV)) {
            this.convMapping = new SmvConverterMapping();
        }
    }

    public String doGenerate(String expression) throws Exception {
        System.out.println("doGenerate");
        XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
        String res = this.doGenerate(xtextResourceUtil.deserializeBaseTypeExpression(expression));
        if (this.context != null) {
            return String.valueOf(res) + " IN " + this.context;
        }
        return res;
    }

    private String doGenerate(Expression rootExpression) {
        System.out.println(rootExpression);
        if (rootExpression == null) {
            return this.convMapping.getTrue();
        }
        this.baseTypeConverter = new BaseTypeConverter(this.convMapping);
        Stack<Expression> toProcess = new Stack<Expression>();
        toProcess.push(rootExpression);
        while (!toProcess.isEmpty()) {
            Expression currExprToProcess = (Expression)toProcess.peek();
            if (this.isProcessed(currExprToProcess)) {
                toProcess.pop();
                continue;
            }
            boolean processCurrExpr = true;
            for (EObject o : currExprToProcess.eContents()) {
                Expression c;
                if (!(o instanceof Expression) || this.isProcessed(c = (Expression)o)) continue;
                processCurrExpr = false;
                toProcess.push(c);
            }
            if (!processCurrExpr) continue;
            toProcess.pop();
            this.process(currExprToProcess);
        }
        String res = this.getProcessedExpr(rootExpression);
        return res;
    }

    private String getProcessedExpr(Expression rootExpression) {
        return (String)this.baseTypeConverter.exprCache.get(rootExpression);
    }

    private void process(Expression currExprToProcess) {
        this.baseTypeConverter.doSwitch((EObject)currExprToProcess);
    }

    private boolean isProcessed(Expression currExprToProcess) {
        return this.baseTypeConverter.exprCache.containsKey(currExprToProcess);
    }

    private class BaseTypeConverter
    extends BaseTypeSwitch<Void> {
        private Map<Expression, String> exprCache;
        private ExpressionConverter expressionConverter;
        private ConverterMapping convMapping;

        public BaseTypeConverter(ConverterMapping convMapping) {
            this.convMapping = convMapping;
            this.exprCache = new HashMap<Expression, String>();
            this.expressionConverter = new ExpressionConverter(this.exprCache, convMapping.getOperatorsMap(), this);
        }

        public Void caseExpression(Expression e) {
            this.expressionConverter.doSwitch((EObject)e);
            return null;
        }

        public Void caseIntegerLiteral(IntegerLiteral l) {
            this.exprCache.put((Expression)l, l.getValue());
            return null;
        }

        public Void caseRealLiteral(RealLiteral l) {
            this.exprCache.put((Expression)l, l.getValue());
            return null;
        }

        public Void caseBooleanLiteral(BooleanLiteral l) {
            String v = l.getValue().toLowerCase();
            this.exprCache.put((Expression)l, v.equals("true") ? this.convMapping.getTrue() : this.convMapping.getFalse());
            return null;
        }

        class ExpressionConverter
        extends ExpressionSwitch<Void> {
            BaseTypeConverter baseTypeConverter;
            Map<String, String> operatorsMap;
            Map<Expression, String> exprCache;

            ExpressionConverter(Map<Expression, String> cache, Map<String, String> operatorsMap, BaseTypeConverter baseTypeConverter2) {
                this.baseTypeConverter = baseTypeConverter2;
                this.exprCache = cache;
                this.operatorsMap = operatorsMap;
            }

            private String getOp(Operator op) {
                String k = op.getName();
                if (this.operatorsMap.containsKey(k)) {
                    return this.operatorsMap.get(k);
                }
                return k;
            }

            public Void caseBoundedExpression(BoundedExpression e) {
                this.exprCache.put((Expression)e, this.exprCache.get(e.getExpression()));
                return null;
            }

            public Void caseFullVariableId(FullVariableId i) {
                VariableId id = i.getId();
                String res = "";
                for (ComponentId cid : i.getFullComponentIds()) {
                    res = String.valueOf(res) + cid.getName() + ".";
                }
                String v = id.getName();
                res = String.valueOf(res) + v;
                this.exprCache.put((Expression)i, res);
                return null;
            }

            public Void caseLogicalExpression(LogicalExpression e) {
                String l = this.exprCache.get(e.getLeft());
                String r = this.exprCache.get(e.getRight());
                Operator op = e.getOp();
                this.putLRExpression((Expression)e, l, r, op);
                return null;
            }

            public Void caseUnaryLogicalExpression(UnaryLogicalExpression e) {
                String a = this.exprCache.get(e.getOperand());
                Operator op = e.getOperator();
                this.exprCache.put((Expression)e, String.valueOf(this.getOp(op)) + " " + a);
                return null;
            }

            public Void caseTemporalExpression(TemporalExpression e) {
                String l = this.exprCache.get(e.getLeft());
                String r = this.exprCache.get(e.getRight());
                Operator op = e.getOp();
                this.exprCache.put((Expression)e, String.valueOf(this.getOp(op)) + "(" + l + ", " + r + ")");
                return null;
            }

            public Void caseUnaryTemporalExpression(UnaryTemporalExpression e) {
                Bound b = e.getBound();
                String bs = "";
                if (b != null) {
                    this.baseTypeConverter.doSwitch((EObject)b.getLower());
                    this.baseTypeConverter.doSwitch((EObject)b.getUpper());
                    String l = this.exprCache.get(b.getLower());
                    String u = this.exprCache.get(b.getUpper());
                    bs = "[" + l + BaseTypeConverter.this.convMapping.getBoundaryIntervalSymbol() + u + "]";
                }
                String a = this.exprCache.get(e.getOperand());
                Operator op = e.getOperator();
                this.exprCache.put((Expression)e, String.valueOf(this.getOp(op)) + bs + "(" + a + ")");
                return null;
            }

            public Void caseEqualityExpression(EqualityExpression e) {
                String l = this.exprCache.get(e.getLeft());
                String r = this.exprCache.get(e.getRight());
                Operator op = e.getOp();
                this.putLRExpression((Expression)e, l, r, op);
                return null;
            }

            public Void caseRelationalExpression(RelationalExpression e) {
                String l = this.exprCache.get(e.getLeft());
                String r = this.exprCache.get(e.getRight());
                Operator op = e.getOp();
                this.putLRExpression((Expression)e, l, r, op);
                return null;
            }

            public Void caseAddSubExpression(AddSubExpression e) {
                String l = this.exprCache.get(e.getLeft());
                String r = this.exprCache.get(e.getRight());
                Operator op = e.getOp();
                this.putLRExpression((Expression)e, l, r, op);
                return null;
            }

            public Void caseMulDivExpression(MulDivExpression e) {
                String l = this.exprCache.get(e.getLeft());
                String r = this.exprCache.get(e.getRight());
                Operator op = e.getOp();
                this.putLRExpression((Expression)e, l, r, op);
                return null;
            }

            private void putLRExpression(Expression e, String l, String r, Operator op) {
                this.exprCache.put(e, "(" + l + " " + this.getOp(op) + " " + r + ")");
            }

            public Void caseExpression(Expression e) {
                if (!this.exprCache.containsKey(e)) {
                    throw new RuntimeException("unhandled: " + e.toString());
                }
                return null;
            }
        }
    }

    private abstract class ConverterMapping {
        private ConverterMapping() {
        }

        public abstract Map<String, String> getOperatorsMap();

        public abstract String getTrue();

        public abstract String getFalse();

        public abstract String getBoundaryIntervalSymbol();
    }

    private class KratosConverterMapping
    extends ConverterMapping {
        private KratosConverterMapping() {
        }

        @Override
        public Map<String, String> getOperatorsMap() {
            HashMap<String, String> operatorsmap = new HashMap<String, String>();
            operatorsmap.put("always", "G");
            operatorsmap.put("in the future", "F");
            operatorsmap.put("historically", "H");
            operatorsmap.put("in the past", "O");
            operatorsmap.put("and", "&");
            operatorsmap.put("or", "|");
            operatorsmap.put("not", "~");
            operatorsmap.put("->", ">>");
            operatorsmap.put("implies", ">>");
            operatorsmap.put("iff", "==");
            operatorsmap.put("<->", "==");
            operatorsmap.put("=", "==");
            operatorsmap.put("until", "U");
            operatorsmap.put("releases", "R");
            operatorsmap.put("since", "S");
            operatorsmap.put("then", "X");
            operatorsmap.put("previously", "Y");
            return operatorsmap;
        }

        @Override
        public String getTrue() {
            return "TRUE";
        }

        @Override
        public String getFalse() {
            return "FALSE";
        }

        @Override
        public String getBoundaryIntervalSymbol() {
            return ":";
        }
    }

    public static enum OutputLanguage {
        KRATOS,
        SMV;

    }

    private class SmvConverterMapping
    extends ConverterMapping {
        private SmvConverterMapping() {
        }

        @Override
        public Map<String, String> getOperatorsMap() {
            HashMap<String, String> operatorsmap = new HashMap<String, String>();
            operatorsmap.put("always", "G");
            operatorsmap.put("in the future", "F");
            operatorsmap.put("historically", "H");
            operatorsmap.put("in the past", "O");
            operatorsmap.put("and", "&");
            operatorsmap.put("or", "|");
            operatorsmap.put("not", "!");
            operatorsmap.put("->", "->");
            operatorsmap.put("implies", "->");
            operatorsmap.put("iff", "<->");
            operatorsmap.put("<->", "<->");
            operatorsmap.put("=", "=");
            operatorsmap.put("until", "U");
            operatorsmap.put("releases", "R");
            operatorsmap.put("since", "S");
            operatorsmap.put("then", "X");
            operatorsmap.put("previously", "Y");
            return operatorsmap;
        }

        @Override
        public String getTrue() {
            return "TRUE";
        }

        @Override
        public String getFalse() {
            return "FALSE";
        }

        @Override
        public String getBoundaryIntervalSymbol() {
            return ",";
        }
    }
}

