/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.services.SMVTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class SmvExportServiceUI {
    private static final Logger logger = Logger.getLogger(SmvExportServiceUI.class);
    private static SmvExportServiceUI instance;
    private SMVTranslatorServiceAPI smvTranslatorServiceAPI;
    private DialogUtil dialogUtil = DialogUtil.getInstance();

    public static SmvExportServiceUI getInstance(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        if (instance == null) {
            instance = new SmvExportServiceUI(abstractSystemModel, abstractStateMachineModel);
        }
        return instance;
    }

    public SmvExportServiceUI(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        this.smvTranslatorServiceAPI = SMVTranslatorServiceAPI.getInstance(abstractSystemModel, abstractStateMachineModel);
    }

    public void exportAllNominalStateMachinesOfTheModel(Object umlModel, String selectedDirectory, boolean showPopups, IProgressMonitor monitor, int timeSpecification) throws Exception {
        logger.debug((Object)("umlModel: " + umlModel));
        this.smvTranslatorServiceAPI.exportAllNominalStateMachinesOfTheModel(umlModel, selectedDirectory, null, monitor, timeSpecification);
        if (showPopups) {
            this.dialogUtil.showMessage_ExportNominalStateMachinesDone(selectedDirectory);
        }
    }

    public void exportNominalStateMachines(Object umlSelectedComponent, String selectedDirectory, boolean showPopups, IProgressMonitor monitor, int timeSpecification) throws Exception {
        this.smvTranslatorServiceAPI.exportNominalStateMachines(umlSelectedComponent, selectedDirectory, null, monitor, timeSpecification);
        if (showPopups) {
            this.dialogUtil.showMessage_ExportNominalStateMachinesDone(selectedDirectory);
        }
    }

    public String exportSingleSmv(Object umlSelectedComponent, boolean showPopups, String selectedDirectory, IProgressMonitor monitor, int timeSpecification) throws Exception {
        File smvFile = this.smvTranslatorServiceAPI.exportStateMachineOfComponentToSMVFile(umlSelectedComponent, showPopups, selectedDirectory, monitor, timeSpecification);
        if (showPopups) {
            this.dialogUtil.showMessage_ExportBehaviourDone(smvFile.getAbsolutePath(), "smv");
        }
        return smvFile.getPath();
    }

    public HashMap<String, String> exportSmv(Object umlSelectedComponent, boolean showPopups, String selectedDirectory, IProgressMonitor monitor, int timeSpecification) throws Exception {
        HashMap<String, String> mapSmvFile_ComponentName = this.smvTranslatorServiceAPI.exportAllStateMachinesToSMVFiles(umlSelectedComponent, selectedDirectory, monitor, timeSpecification);
        logger.debug((Object)"exportSmv done");
        if (showPopups) {
            this.dialogUtil.showMessage_ExportBehaviourDone(selectedDirectory, "smv");
        }
        return mapSmvFile_ComponentName;
    }
}

