/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.nusmv.smv.Model;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public class SmvModelUtil {
    private static final Logger logger = Logger.getLogger(SmvModelUtil.class);
    private static SmvModelUtil smvModelUtil;
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
    SaveOptions noValidOptions = SaveOptions.newBuilder().noValidation().getOptions();

    public static SmvModelUtil getInstance() {
        if (smvModelUtil == null) {
            smvModelUtil = new SmvModelUtil();
        }
        return smvModelUtil;
    }

    public File generateSmvFileFromSmvModel(String selectedDirectory, String fileName, Object smvModel, IProgressMonitor monitor) throws Exception {
        monitor.subTask("generate Smv File model from Smv Model");
        File smvFile = this.generateSmvFile(fileName, (Model)smvModel, selectedDirectory);
        monitor.worked(1);
        return smvFile;
    }

    public File generateSmvFile(String fileName, Model ossModel, String workspaceDir) throws IOException {
        logger.debug((Object)"generateSmvFile");
        File smvFile = fileName == null ? FileSystemUtil.generateEmptyFile((String)".smv", (String)workspaceDir) : FileSystemUtil.generateEmptyFile((String)fileName, (String)".smv", (String)workspaceDir);
        BufferedWriter bw = new BufferedWriter(new FileWriter(smvFile));
        this.generateText(bw, ossModel);
        bw.close();
        return smvFile;
    }

    private void generateText(Writer writer, Model smvModel) throws IOException {
        if (writer == null) {
            return;
        }
        Injector injector = this.xtextResourceUtil.getNuSMVInjector();
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        SaveOptions saveOpt = SaveOptions.newBuilder().format().getOptions();
        String serialization = serializer.serialize((EObject)smvModel, saveOpt);
        logger.debug((Object)("SMV: " + serialization));
        writer.append(serialization);
        logger.debug((Object)"SMV file generation completed");
    }

    public String getSmvElementAsString(EObject smvElement, boolean validateElement, boolean removeWhiteSpaces) {
        Injector injector = this.xtextResourceUtil.getNuSMVInjector();
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        if (!validateElement) {
            String string = serializer.serialize(smvElement, this.noValidOptions);
        }
        String str = serializer.serialize(smvElement);
        return removeWhiteSpaces ? str.trim() : str;
    }
}

