/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram.ui.docGenerators;

import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.eclipse.standardtools.diagram.AssertionDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ComponentDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ConnectionDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContainerDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ContractRefinementDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DefineDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DiagramDescriptor;
import eu.fbk.eclipse.standardtools.diagram.DocumentGenerator;
import eu.fbk.eclipse.standardtools.diagram.LocalAttributeDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ParameterAssumptionsDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ParameterDescriptor;
import eu.fbk.eclipse.standardtools.diagram.PortDescriptor;
import eu.fbk.eclipse.standardtools.diagram.SubComponentDescriptor;
import eu.fbk.eclipse.standardtools.diagram.UninterpretedFunctionDescriptor;
import eu.fbk.eclipse.standardtools.diagram.ui.services.DiagramDialogUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.ParameterAssumptions;
import eu.fbk.tools.editor.oss.oss.Port;
import eu.fbk.tools.editor.oss.oss.RefinedBy;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.Variable;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;

public class DocumentGeneratorServiceFromOssModel {
    private boolean validateSerializedElement = false;
    private OSS ossModel;
    private AbstractSystemModel abstractSystemModel;
    private OSSModelUtil ocraModelUtil = OSSModelUtil.getInstance();
    private Object activePackage;
    private String directoryName;
    private String imageExtension;
    private boolean showLeafComponents = true;
    private final String CONTRACT_SPECIFICATION = "CONTRACT_SPECIFICATION";
    private boolean showInputPorts = true;
    private boolean showOutputPorts = true;
    private boolean showSubComponents = true;
    private boolean showParameters = true;
    private boolean showUninterpretedFunctions = true;
    private boolean showConnections = true;
    private boolean showInterfaceAssertions = true;
    private boolean showRefinementAssertions = true;
    private boolean showContracts = true;
    private boolean showContractRefinements = true;
    private boolean showParameterAssumptions = true;
    private boolean showDiagrams = true;
    private boolean showLocalAttributes = true;
    private boolean showDefines = true;

    public DocumentGeneratorServiceFromOssModel(OSS ossModel, AbstractSystemModel abstractSystemModel, Object activePackage) {
        this.ossModel = ossModel;
        this.abstractSystemModel = abstractSystemModel;
        this.activePackage = activePackage;
    }

    public void setParametersBeforeDocumentGeneration(String directoryName, String imageExtension, boolean showLeafComponents, boolean showInputPorts, boolean showOutputPorts, boolean showSubComponents, boolean showParameters, boolean showUninterpretedFunctions, boolean showConnections, boolean showInterfaceAssertions, boolean showRefinementAssertions, boolean showContracts, boolean showContractRefinements, boolean showParameterAssumptions, boolean showDiagrams, boolean showLocalAttributes, boolean showDefines) {
        this.imageExtension = imageExtension;
        this.directoryName = directoryName;
        this.showLeafComponents = showLeafComponents;
        this.showInputPorts = showInputPorts;
        this.showOutputPorts = showOutputPorts;
        this.showSubComponents = showSubComponents;
        this.showParameters = showParameters;
        this.showUninterpretedFunctions = showUninterpretedFunctions;
        this.showConnections = showConnections;
        this.showInterfaceAssertions = showInterfaceAssertions;
        this.showRefinementAssertions = showRefinementAssertions;
        this.showContracts = showContracts;
        this.showContractRefinements = showContractRefinements;
        this.showParameterAssumptions = showParameterAssumptions;
        this.showDiagrams = showDiagrams;
        this.showLocalAttributes = showLocalAttributes;
        this.showDefines = showDefines;
    }

    public DocumentGenerator createDocumentFile(String currentProjectName, String docFormat, AbstractComponent selectedComponent, IProgressMonitor monitor) {
        monitor.beginTask("Creating Document File", 1);
        DocumentGenerator documentGenerator = new DocumentGenerator();
        documentGenerator.init(currentProjectName, docFormat);
        ContainerDescriptor rootContainerDescriptor = this.createContainerDescriptor("Model", monitor);
        this.enrichDiagramDescriptorWithComponentTypeInfo(selectedComponent, rootContainerDescriptor, monitor);
        if (this.showLeafComponents) {
            this.enrichDiagramDescriptorWithSubComponentTypeInfo(selectedComponent, rootContainerDescriptor, monitor);
        }
        documentGenerator.setContainerDescriptor(rootContainerDescriptor);
        monitor.done();
        return documentGenerator;
    }

    public void generateDocument(DocumentGenerator documentGenerator) {
        documentGenerator.generate(this.directoryName);
        DiagramDialogUtil.getInstance().showMessage_DocumentationGenerated(this.directoryName);
    }

    public void addDiagramDescriptors(Set<DiagramDescriptor> diagramDescriptors, DocumentGenerator documentGenerator) {
        if (!this.showDiagrams) {
            return;
        }
        ArrayList<ContainerDescriptor> enrichedContainers = new ArrayList<ContainerDescriptor>();
        for (DiagramDescriptor diagramDescriptor : diagramDescriptors) {
            ContainerDescriptor containerDescriptor = null;
            containerDescriptor = !diagramDescriptor.hasComponentOwner ? this.getContainerWithNoComponentOwner(documentGenerator) : this.getContainerWithComponentNameEqualTo(diagramDescriptor.ownerName, documentGenerator);
            if (containerDescriptor == null) continue;
            containerDescriptor.diagrams.add(diagramDescriptor);
            enrichedContainers.add(containerDescriptor);
        }
        Comparator<DiagramDescriptor> comparator = new Comparator<DiagramDescriptor>(){

            @Override
            public int compare(DiagramDescriptor left, DiagramDescriptor right) {
                return Integer.compare(left.weight, right.weight);
            }
        };
        for (ContainerDescriptor containerDescriptor : enrichedContainers) {
            containerDescriptor.diagrams.sort(comparator);
        }
    }

    private ContainerDescriptor getContainerWithNoComponentOwner(DocumentGenerator documentGenerator) {
        return documentGenerator.getRootContainerDescriptor();
    }

    private ContainerDescriptor getContainerWithComponentNameEqualTo(String componentName, DocumentGenerator documentGenerator) {
        for (ContainerDescriptor containerDescriptor : documentGenerator.getContainerDescriptors()) {
            if (containerDescriptor.name == null || containerDescriptor.name.compareTo(componentName) != 0) continue;
            return containerDescriptor;
        }
        return null;
    }

    public String getComponentImageFilePath(String fileName) {
        return String.valueOf(this.directoryName) + File.separator + fileName + this.imageExtension;
    }

    private void enrichDiagramDescriptorWithSubComponentTypeInfo(AbstractComponent parentComponent, ContainerDescriptor parentDescriptor, IProgressMonitor monitor) {
        for (Component component : this.ossModel.getComponents()) {
            this.enrichDiagramDescriptorWithComponentTypeInfo((AbstractComponent)component, parentDescriptor, monitor);
        }
    }

    private void enrichDiagramDescriptorWithComponentTypeInfo(AbstractComponent component, ContainerDescriptor parentDescriptor, IProgressMonitor monitor) {
        String componentType = component.getType();
        if (component instanceof SystemComponent && componentType == null) {
            componentType = "System";
        }
        ComponentDescriptor componentDescriptor = this.createSubComponentDescriptor(component);
        ContainerDescriptor containerDescriptor = this.createContainerDescriptor(componentType, monitor);
        containerDescriptor.createNewSpecification("CONTRACT_SPECIFICATION", "contracts");
        this.addContracts(containerDescriptor, component);
        containerDescriptor.componentDescriptor = componentDescriptor;
        parentDescriptor.children.add(containerDescriptor);
    }

    private void addContracts(ContainerDescriptor descriptor, AbstractComponent component) {
        String definitions = this.ocraModelUtil.getContractsText(component, this.validateSerializedElement);
        if (definitions != null && !definitions.isEmpty()) {
            descriptor.specifications.put("CONTRACT_SPECIFICATION", definitions);
        }
    }

    public ContainerDescriptor createContainerDescriptor(String elementName, IProgressMonitor monitor) {
        ContainerDescriptor diagramDescriptor = new ContainerDescriptor();
        diagramDescriptor.name = elementName;
        return diagramDescriptor;
    }

    private ComponentDescriptor createSubComponentDescriptor(AbstractComponent component) {
        Assertion assertion;
        PortDescriptor descriptor;
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.type = component instanceof SystemComponent ? "System" : component.getType();
        componentDescriptor.refinementType = this.getRefinementType(component);
        for (InterfaceInstance interfaceInstance : component.getInterface().getInterfaces()) {
            if (interfaceInstance.getVariable() != null) {
                UninterpretedFunctionDescriptor descriptor2;
                Variable variable = interfaceInstance.getVariable();
                if (variable instanceof Port) {
                    descriptor = this.getPortDescriptor(component, (Port)variable);
                    if (descriptor == null) continue;
                    if (this.showInputPorts && this.ocraModelUtil.isInputPort(variable)) {
                        componentDescriptor.inputPortDescriptors.add(descriptor);
                        continue;
                    }
                    if (!this.showOutputPorts || !this.ocraModelUtil.isOutputPort(variable)) continue;
                    componentDescriptor.outputPortDescriptors.add(descriptor);
                    continue;
                }
                if (!(variable instanceof Parameter)) continue;
                EList parametersTypes = ((Parameter)variable).getParameters();
                if (parametersTypes.size() != 0) {
                    if (!this.showUninterpretedFunctions) continue;
                    descriptor2 = this.getUninterpretedFunctionDescriptor((Parameter)variable);
                    componentDescriptor.uninterpretedFunctionDescriptors.add(descriptor2);
                    continue;
                }
                if (!this.showParameters) continue;
                descriptor2 = this.getParameterDescriptor(component, (Parameter)variable);
                componentDescriptor.parameterDescriptors.add(descriptor2);
                continue;
            }
            if (this.showContracts && interfaceInstance.getContract() != null) {
                Contract contract = interfaceInstance.getContract();
                descriptor = this.getContractDescriptor(component, contract);
                componentDescriptor.contractDescriptors.add(descriptor);
                continue;
            }
            if (this.showInterfaceAssertions && interfaceInstance.getAssertion() != null) {
                assertion = interfaceInstance.getAssertion();
                descriptor = this.getAssertionDescriptor(assertion);
                componentDescriptor.interfaceAssertionDescriptors.add(descriptor);
                continue;
            }
            if (this.showParameterAssumptions && interfaceInstance.getParameterAssumptions() != null) {
                ParameterAssumptions parameterAssumptions = interfaceInstance.getParameterAssumptions();
                descriptor = this.getParameterAssumptionsDescriptor(parameterAssumptions);
                componentDescriptor.parameterAssumptionsDescriptors.add(descriptor);
                continue;
            }
            if (!this.showDefines || interfaceInstance.getDefine() == null) continue;
            Define define = interfaceInstance.getDefine();
            descriptor = this.getDefineDescriptor(define);
            componentDescriptor.defineDescriptors.add(descriptor);
        }
        if (component.getRefinement() != null) {
            for (RefinementInstance refinementInstance : component.getRefinement().getRefinements()) {
                RefinedBy refinedBy;
                if (this.showSubComponents && refinementInstance.getSubcomponent() != null) {
                    SubComponent subComponent = refinementInstance.getSubcomponent();
                    if (subComponent == null) continue;
                    descriptor = this.getSubComponentDescriptor(subComponent);
                    componentDescriptor.subComponentDescriptors.add(descriptor);
                    continue;
                }
                if (this.showConnections && refinementInstance.getConnection() != null) {
                    Connection connection = refinementInstance.getConnection();
                    if (connection == null) continue;
                    if (connection.getConstraint() instanceof FullPortId) {
                        descriptor = this.getConnectionDescriptor(connection);
                        componentDescriptor.connectionDescriptors.add(descriptor);
                        continue;
                    }
                    if (!(connection.getConstraint() instanceof Expression)) continue;
                    descriptor = this.getDelegationConstraintDescriptor(connection);
                    componentDescriptor.connectionDescriptors.add(descriptor);
                    continue;
                }
                if (this.showRefinementAssertions && refinementInstance.getAssertion() != null) {
                    assertion = refinementInstance.getAssertion();
                    if (assertion == null) continue;
                    descriptor = this.getAssertionDescriptor(assertion);
                    componentDescriptor.refinementAssertionDescriptors.add(descriptor);
                    continue;
                }
                if (!this.showContractRefinements || refinementInstance.getRefinedby() == null || (refinedBy = refinementInstance.getRefinedby()) == null) continue;
                descriptor = this.getContractRefinementDescriptor(refinedBy);
                componentDescriptor.contractRefinementDescriptors.add(descriptor);
            }
        }
        return componentDescriptor;
    }

    private ContractRefinementDescriptor getContractRefinementDescriptor(RefinedBy refinedBy) {
        ContractRefinementDescriptor descriptor = new ContractRefinementDescriptor();
        descriptor.refinedContractName = refinedBy.getName();
        String refiningContracts = "";
        boolean firstElement = true;
        for (FullContractIdList contractId : refinedBy.getFullContractIds()) {
            if (!firstElement) {
                refiningContracts = refiningContracts.concat(",");
            }
            refiningContracts = refiningContracts.concat(this.ocraModelUtil.getFullContractIdAsString(contractId, this.validateSerializedElement));
            firstElement = false;
        }
        descriptor.refiningContractsNames = refiningContracts;
        return descriptor;
    }

    private String getVariableType(String componentName, Variable variable, String portName) {
        String portType = this.abstractSystemModel.getPortTypeAsStringName(this.activePackage, componentName, portName);
        if (this.ocraModelUtil.isEnumTypeVariable(variable)) {
            portType = String.valueOf(portType) + " - Enum " + this.ocraModelUtil.getVariableEnumTypeValuesAsStr(variable);
        } else if (this.ocraModelUtil.isRangeTypeVariable(variable)) {
            portType = String.valueOf(portType) + " - Range " + this.ocraModelUtil.getVariableRangeAsStr(variable);
        } else if (this.ocraModelUtil.isEventType(variable)) {
            portType = String.valueOf(portType) + " - Event";
        }
        return portType;
    }

    private PortDescriptor getPortDescriptor(AbstractComponent component, Port port) {
        PortDescriptor descriptor = new PortDescriptor();
        descriptor.name = this.ocraModelUtil.getPortName(port, this.validateSerializedElement);
        descriptor.type = this.getVariableType(component.getType(), (Variable)port, descriptor.name);
        String[] boundaries = this.ocraModelUtil.getMultiplicityBoundariesFromOssComplexType(port.getType(), this.validateSerializedElement);
        if (boundaries[0] != null) {
            descriptor.type = String.valueOf(descriptor.type) + " [";
            descriptor.type = String.valueOf(descriptor.type) + boundaries[0];
            if (!boundaries[0].equals(boundaries[1])) {
                descriptor.type = String.valueOf(descriptor.type) + ".." + boundaries[1];
            }
            descriptor.type = String.valueOf(descriptor.type) + "]";
        }
        if (this.ocraModelUtil.isInputPort((Variable)port)) {
            descriptor.direction = "input";
        } else if (this.ocraModelUtil.isOutputPort((Variable)port)) {
            descriptor.direction = "output";
        } else {
            return null;
        }
        descriptor.notes = "";
        return descriptor;
    }

    private ParameterDescriptor getParameterDescriptor(AbstractComponent component, Parameter parameter) {
        ParameterDescriptor descriptor = new ParameterDescriptor();
        descriptor.name = this.ocraModelUtil.getVariableIdAsString(parameter.getId(), this.validateSerializedElement);
        descriptor.type = this.getVariableType(component.getType(), (Variable)parameter, descriptor.name);
        String[] boundaries = this.ocraModelUtil.getMultiplicityBoundariesFromOssComplexType(parameter.getType(), this.validateSerializedElement);
        if (boundaries[0] != null) {
            descriptor.type = String.valueOf(descriptor.type) + " [";
            descriptor.type = String.valueOf(descriptor.type) + boundaries[0];
            if (!boundaries[0].equals(boundaries[1])) {
                descriptor.type = String.valueOf(descriptor.type) + ".." + boundaries[1];
            }
            descriptor.type = String.valueOf(descriptor.type) + "]";
        }
        return descriptor;
    }

    private UninterpretedFunctionDescriptor getUninterpretedFunctionDescriptor(Parameter parameter) {
        UninterpretedFunctionDescriptor descriptor = new UninterpretedFunctionDescriptor();
        descriptor.name = this.ocraModelUtil.getVariableIdAsString(parameter.getId(), this.validateSerializedElement);
        descriptor.type = this.ocraModelUtil.getTypeAsStr(parameter.getType());
        String[] boundaries = this.ocraModelUtil.getMultiplicityBoundariesFromOssComplexType(parameter.getType(), this.validateSerializedElement);
        if (boundaries[0] != null) {
            descriptor.type = String.valueOf(descriptor.type) + " [";
            descriptor.type = String.valueOf(descriptor.type) + boundaries[0];
            if (!boundaries[0].equals(boundaries[1])) {
                descriptor.type = String.valueOf(descriptor.type) + ".." + boundaries[1];
            }
            descriptor.type = String.valueOf(descriptor.type) + "]";
        }
        descriptor.input = this.ocraModelUtil.getUninterpretedFunctionInputsAsStr((Variable)parameter, this.validateSerializedElement);
        return descriptor;
    }

    private ContractDescriptor getContractDescriptor(AbstractComponent component, Contract contract) {
        ContractDescriptor descriptor = new ContractDescriptor();
        descriptor.name = this.ocraModelUtil.getContractName(contract);
        descriptor.assumption = this.ocraModelUtil.getContractAssumption(contract, this.validateSerializedElement);
        descriptor.guarantee = this.ocraModelUtil.getContractGuarantee(contract, this.validateSerializedElement);
        Expression expression = contract.getAssumption().getConstraint();
        if (this.ocraModelUtil.isAssertionID(component, expression)) {
            descriptor.assumptionLink = String.valueOf(component.getType()) + "." + descriptor.assumption.substring(0, descriptor.assumption.indexOf(" "));
        }
        if (this.ocraModelUtil.isAssertionID(component, expression = contract.getGuarantee().getConstraint())) {
            descriptor.guaranteeLink = String.valueOf(component.getType()) + "." + descriptor.guarantee.substring(0, descriptor.guarantee.indexOf(" "));
        }
        return descriptor;
    }

    private AssertionDescriptor getAssertionDescriptor(Assertion assertion) {
        AssertionDescriptor descriptor = new AssertionDescriptor();
        descriptor.name = this.ocraModelUtil.getAssertionName(assertion);
        descriptor.text = this.ocraModelUtil.getAssertionText(assertion, this.validateSerializedElement);
        return descriptor;
    }

    private ConnectionDescriptor getConnectionDescriptor(Connection connection) {
        ConnectionDescriptor descriptor = new ConnectionDescriptor();
        descriptor.port1 = this.ocraModelUtil.getTargetPort(connection, this.validateSerializedElement);
        descriptor.port2 = this.ocraModelUtil.getSourcePort(connection, this.validateSerializedElement);
        descriptor.iterativeCondition = this.ocraModelUtil.getIterativeConditionAsString(connection, this.validateSerializedElement);
        return descriptor;
    }

    private ConnectionDescriptor getDelegationConstraintDescriptor(Connection connection) {
        ConnectionDescriptor descriptor = new ConnectionDescriptor();
        descriptor.port1 = this.ocraModelUtil.getTargetPort(connection, this.validateSerializedElement);
        descriptor.port2 = this.ocraModelUtil.getDelegationAsString(connection, this.validateSerializedElement);
        descriptor.iterativeCondition = this.ocraModelUtil.getIterativeConditionAsString(connection, this.validateSerializedElement);
        return descriptor;
    }

    private SubComponentDescriptor getSubComponentDescriptor(SubComponent subcomponent) {
        SubComponentDescriptor descriptor = new SubComponentDescriptor();
        descriptor.name = this.ocraModelUtil.getSubComponentName(subcomponent, this.validateSerializedElement);
        descriptor.type = this.ocraModelUtil.getSubComponentTypeName(subcomponent);
        String[] boundaries = this.ocraModelUtil.getMultiplicityBoundariesFromOssSubComponentType(subcomponent.getType(), this.validateSerializedElement);
        if (boundaries[0] != null) {
            descriptor.multiplicity = " [";
            descriptor.multiplicity = String.valueOf(descriptor.multiplicity) + boundaries[0];
            if (!boundaries[0].equals(boundaries[1])) {
                descriptor.multiplicity = String.valueOf(descriptor.multiplicity) + ".." + boundaries[1];
            }
            descriptor.multiplicity = String.valueOf(descriptor.multiplicity) + "]";
        }
        return descriptor;
    }

    private ParameterAssumptionsDescriptor getParameterAssumptionsDescriptor(ParameterAssumptions parameterAssumptions) {
        ParameterAssumptionsDescriptor descriptor = new ParameterAssumptionsDescriptor();
        descriptor.text = this.ocraModelUtil.getParameterAssumptionsText(parameterAssumptions, this.validateSerializedElement);
        return descriptor;
    }

    private String getRefinementType(Object component) {
        return "";
    }

    private LocalAttributeDescriptor getLocalAttributeDescriptor(Object localAttribute) {
        LocalAttributeDescriptor descriptor = new LocalAttributeDescriptor();
        descriptor.name = this.abstractSystemModel.getLocalAttributeName(localAttribute);
        descriptor.type = this.abstractSystemModel.getLocalAttributeType(localAttribute);
        return descriptor;
    }

    public void addLocalAttributeDescriptors(Object rootComponent, DocumentGenerator documentGenerator) {
        if (!this.showLocalAttributes) {
            return;
        }
        Object componentType = this.abstractSystemModel.getComponentType(rootComponent);
        String rootComponentName = this.abstractSystemModel.getComponentName(componentType);
        ContainerDescriptor rootContainer = this.getContainerWithComponentNameEqualTo(rootComponentName, documentGenerator);
        EList localAttributes = this.abstractSystemModel.getLocalAttributes(rootComponent);
        for (Object localAttribute : localAttributes) {
            rootContainer.componentDescriptor.localAttributesDescriptors.add(this.getLocalAttributeDescriptor(localAttribute));
        }
        EList subComponents = this.abstractSystemModel.getSubComponentsInstances(rootComponent);
        for (Object subComponent : subComponents) {
            this.addLocalAttributeDescriptors(subComponent, documentGenerator);
        }
    }

    private DefineDescriptor getDefineDescriptor(Define define) {
        DefineDescriptor descriptor = new DefineDescriptor();
        descriptor.name = this.ocraModelUtil.getDefineName(define);
        descriptor.text = this.ocraModelUtil.getDefineText(define, this.validateSerializedElement);
        return descriptor;
    }
}

