/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UserDataType;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.value.DataType;

public class CreateUserDataType
extends DefineCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;

    public CreateUserDataType(Session session) {
        super(session);
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (database.findUserDataType(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90119, this.typeName);
        }
        DataType dataType = DataType.getTypeByName(this.typeName);
        if (dataType != null) {
            if (!dataType.hidden) {
                throw DbException.get(90119, this.typeName);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                throw DbException.get(90119, this.typeName + " (" + table.getSQL() + ")");
            }
        }
        int n = this.getObjectId();
        UserDataType userDataType = new UserDataType(database, n, this.typeName);
        userDataType.setColumn(this.column);
        database.addDatabaseObject(this.session, userDataType);
        return 0;
    }

    public int getType() {
        return 33;
    }
}

