/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.EasingFunctionBase;

public class ElasticEase
extends EasingFunctionBase {
    private int oscillations = 3;
    private double springiness = 3.0;

    public int getOscillations() {
        return this.oscillations;
    }

    public void setOscillations(int oscillations) {
        this.oscillations = oscillations;
    }

    public double getSpringiness() {
        return this.springiness;
    }

    public void setSpringiness(double springiness) {
        this.springiness = springiness;
    }

    @Override
    public double ease(double normalizedTime) {
        switch (this.getEasingMode()) {
            case EaseIn: {
                return this.easeValue(normalizedTime, this.getOscillations(), this.getSpringiness());
            }
            case EaseOut: {
                return 1.0 - this.easeValue(1.0 - normalizedTime, this.getOscillations(), this.getSpringiness());
            }
            case EaseInOut: {
                normalizedTime /= 0.5;
                if (normalizedTime < 1.0) {
                    return this.easeValue(normalizedTime, this.getOscillations(), this.getSpringiness()) / 2.0;
                }
                return (2.0 - this.easeValue(2.0 - normalizedTime, this.getOscillations(), this.getSpringiness())) / 2.0;
            }
        }
        throw new XWTException(String.valueOf(this.getEasingMode().name()) + " is supported.");
    }

    protected double easeValue(double current, int oscillations, double springiness) {
        if (current == 0.0) {
            return 0.0;
        }
        if (current == 1.0) {
            return 1.0;
        }
        double s = Math.asin(1.0) / (Math.PI * 2 * (double)oscillations);
        return -(Math.pow(2.0, 10.0 * (current -= 1.0)) * Math.sin((current - s) * (Math.PI * 2) * (double)oscillations));
    }
}

