/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.WarningDialog;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DialogUtil {
    private static DialogUtil dialogUtilInstance;

    public static DialogUtil getInstance() {
        if (dialogUtilInstance == null) {
            dialogUtilInstance = new DialogUtil();
        }
        return dialogUtilInstance;
    }

    public IFile getIFileFromFileDialog(String basePath, String fileExtension) {
        File file = this.getFileFromFileDialog(basePath, fileExtension);
        return this.getIFile(file);
    }

    public IFile getIFile(File file) {
        IFile iFile = null;
        if (file != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)file.getAbsolutePath());
            iFile = workspace.getRoot().getFileForLocation(location);
        }
        return iFile;
    }

    public File getFileFromFileDialog(String basePath, String fileExtension) {
        File file = null;
        String pathName = this.getFilePathFromFileDialog(Display.getCurrent().getActiveShell(), basePath, fileExtension, false);
        if (pathName != null) {
            file = new File(pathName);
        }
        return file;
    }

    public String getFilePathFromFileDialog(String basePath, String fileExtension) {
        return this.getFilePathFromFileDialog(Display.getCurrent().getActiveShell(), basePath, fileExtension, false);
    }

    public String getFilePathFromFileDialog(String basePath, String fileExtension, boolean save) {
        return this.getFilePathFromFileDialog(Display.getCurrent().getActiveShell(), basePath, fileExtension, save);
    }

    private String getFilePathFromFileDialog(Shell shell, String basePath, String fileExtension, boolean save) {
        FileDialog dialog = new FileDialog(shell, save ? 8192 : 4096);
        if (fileExtension != null) {
            dialog.setFilterExtensions(new String[]{fileExtension});
        }
        dialog.setFilterPath(basePath);
        return dialog.open();
    }

    public void showMessage_ExceptionError(final Exception exception) {
        final Display defaultDisplay = Display.getDefault();
        if (!defaultDisplay.isDisposed()) {
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    if (currShell != null && !currShell.isDisposed()) {
                        String message = "";
                        message = exception.getMessage() != null ? exception.getMessage() : exception.toString();
                        MessageDialog.openError((Shell)currShell, (String)"Error", (String)message);
                    }
                }
            });
        }
    }

    public void showMessage_ExportBehaviourDone(final String filePath, final String extension) {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currShell = defaultDisplay.getActiveShell();
                MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)("The behaviour of the system is exported as ." + extension + " file in " + filePath + "."));
            }
        });
    }

    public void showMessage_ExportNominalStateMachinesDone(final String filePath) {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currShell = defaultDisplay.getActiveShell();
                MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)("The nominal state machines of the system are exported as .smv files in " + filePath + "."));
            }
        });
    }

    public void showMessage_NoStateMachine() {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currShell = defaultDisplay.getActiveShell();
                MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)"No nominal state machine is associated to the selected component.");
            }
        });
    }

    public void showMessage_GenericMessage(final String title, final String message) {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currShell = defaultDisplay.getActiveShell();
                MessageDialog.openInformation((Shell)currShell, (String)title, (String)message);
            }
        });
    }

    public void showErrorMessages(final String title, final List<Exception> errors, Display defaultDisplay, final Shell currShell, String pluginID) {
        if (errors != null && errors.size() > 0) {
            final MultiStatus info = new MultiStatus(pluginID, 1, "Clicca su \"Details\" per vedere la lista delle modifiche.", null);
            for (Exception error : errors) {
                error.printStackTrace();
                info.add((IStatus)new Status(1, pluginID, 1, error.getMessage(), null));
            }
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    String message = String.valueOf(title) + "\n" + "Trovati " + errors.size() + " errori:";
                    WarningDialog.openError(currShell, title, message, (IStatus)info);
                }
            });
        }
    }

    public String getDirectoryNameFromDialog() throws Exception {
        return this.getDirectoryNameFromDialog("Select the directory");
    }

    public String getDirectoryNameFromDialog(String title) throws Exception {
        return this.getDirectoryNameFromDialog(title, DirectoryUtil.getInstance().getCurrentProjectDir());
    }

    public String getDirectoryNameFromDialog(String title, String path) throws Exception {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.setText(title);
        directoryDialog.setFilterPath(path);
        String directoryName = directoryDialog.open();
        return directoryName;
    }
}

