/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.dialogs;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectArchitectureConfigurationDialog
extends Dialog {
    AbstractSystemModel systemModel;
    CCombo instantiatedArchitectureCombo;
    Table parametersTable;
    private SelectionListener InstantiateArchitectureListener;
    EList<?> instantiatedArchitectureConfigurations;
    Object selectedArchitectureConfiguration;
    private boolean goAhead = false;

    public SelectArchitectureConfigurationDialog(Shell parentShell, final AbstractSystemModel systemModel, final EList<?> instantiatedArchitectureConfigurations) {
        super(parentShell);
        this.setShellStyle(48);
        this.systemModel = systemModel;
        this.instantiatedArchitectureConfigurations = instantiatedArchitectureConfigurations;
        this.InstantiateArchitectureListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectArchitectureConfigurationDialog.this.parametersTable.removeAll();
                int selInd = SelectArchitectureConfigurationDialog.this.instantiatedArchitectureCombo.getSelectionIndex();
                if (selInd != -1) {
                    for (String param : systemModel.getParametersListFromInstantiatedArchitectureConfiguration(instantiatedArchitectureConfigurations.get(selInd))) {
                        TableItem item = new TableItem(SelectArchitectureConfigurationDialog.this.parametersTable, 0);
                        item.setText(param);
                    }
                    SelectArchitectureConfigurationDialog.this.selectedArchitectureConfiguration = instantiatedArchitectureConfigurations.get(selInd);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected void okPressed() {
        this.goAhead = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd_combo = new GridData(768);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        container2.setLayoutData((Object)gd_combo);
        Label contextAnalysisLabel = new Label(container2, 0);
        contextAnalysisLabel.setText("Instantiated Architecture");
        this.instantiatedArchitectureCombo = new CCombo(container2, 2060);
        for (Object archConf : this.instantiatedArchitectureConfigurations) {
            this.instantiatedArchitectureCombo.add(this.systemModel.getInstantiatedArchitectureConfigurationName(archConf));
        }
        this.instantiatedArchitectureCombo.addSelectionListener(this.InstantiateArchitectureListener);
        this.instantiatedArchitectureCombo.setLayoutData((Object)gd_combo);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 380;
        this.parametersTable = new Table(container, 2816);
        this.parametersTable.setLayoutData((Object)gridData);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(350, 520);
    }

    public Object getSelectedAchitectureConfiguration() {
        return this.selectedArchitectureConfiguration;
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public int open() {
        return super.open();
    }
}

