/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.NodePositionSyncDispatcher;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.NotationSyncPolicyDelegate;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class NodePositionSyncFeature<M extends EObject, T extends EditPart>
extends SyncFeature<M, T, Notification> {
    private EMFDispatchManager<Dispatcher> dispatchMgr = this.createSingleDispatchManager();

    public NodePositionSyncFeature(SyncBucket<M, T, Notification> bucket) {
        super(bucket);
    }

    public void observe(SyncItem<M, T> item) {
        this.dispatchMgr.add(item, (EMFDispatch)new Dispatcher(item));
    }

    public void unobserve(SyncItem<M, T> item) {
        this.dispatchMgr.remove(item);
    }

    protected void onClear() {
        this.dispatchMgr.removeAll();
    }

    public void synchronize(SyncItem<M, T> from, SyncItem<M, T> to, Notification message) {
        Point locationTo;
        EditPart fromEditPart = (EditPart)from.getBackend();
        EditPart toEditPart = (EditPart)to.getBackend();
        Point locationFrom = this.getLocation(fromEditPart);
        if (!locationFrom.equals((Object)(locationTo = this.getLocation(toEditPart)))) {
            Command reaction = GMFtoEMFCommandWrapper.wrap((ICommand)new SetBoundsCommand(this.getEditingDomain(), "Synchronize Node Location", (IAdaptable)toEditPart, locationFrom));
            if (message == null) {
                this.execute(reaction);
            } else {
                Dispatcher dispatcher = (Dispatcher)this.dispatchMgr.getDispatcher(from, message.getFeature());
                if (dispatcher != null) {
                    dispatcher.react(reaction);
                }
            }
        }
    }

    Point getLocation(EditPart editPart) {
        Point result = null;
        Node node = (Node)editPart.getModel();
        Location location = (Location)TypeUtils.as((Object)node.getLayoutConstraint(), Location.class);
        if (location != null) {
            result = new Point(location.getX(), location.getY());
        } else {
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            result = figure.getBounds().getLocation();
        }
        return result;
    }

    public static <M extends EObject, T extends EditPart> NotationSyncPolicyDelegate<M, T> createPolicyDelegate() {
        return new NotationSyncPolicyDelegate<M, T>(NotationPackage.Literals.LOCATION.getName()){

            protected EMFDispatch createDispatcher(SyncItem<M, T> syncTarget) {
                return new NodePositionSyncDispatcher<M, T>(syncTarget){

                    public void onClear() {
                    }

                    @Override
                    protected void onFilteredChange(Notification notification) {
                        this.overrideOccurred(this, this.getItem());
                    }
                };
            }
        };
    }

    private class Dispatcher
    extends NodePositionSyncDispatcher<M, T> {
        public Dispatcher(SyncItem<M, T> item) {
            super(item);
        }

        public void onClear() {
            NodePositionSyncFeature.this.getBucket().clear();
        }

        @Override
        protected void onFilteredChange(Notification notification) {
            NodePositionSyncFeature.this.onChange(this.item, notification);
        }
    }
}

