/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.locator;

import org.eclipse.draw2d.AbstractLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.PapyrusLabelHelper;

public class PapyrusLabelLocator
extends AbstractLocator {
    private int alignment;
    private Dimension extent;
    private Point margin = new Point();
    private Point offset;
    protected IFigure parent;
    private int textAlignment = 16;
    private View view;
    public static final String IS_UPDATED_POSITION = "IS_UPDATED_POSITION";

    public PapyrusLabelLocator(IFigure parent, Point offSet, int alignment) {
        this.parent = parent;
        this.offset = offSet;
        this.alignment = alignment;
    }

    public PapyrusLabelLocator(IFigure parent, Rectangle bounds, int alignment) {
        this(parent, bounds.getLocation(), alignment);
        this.extent = bounds.getSize();
    }

    public int getAlignment() {
        return this.alignment;
    }

    private int getLocation() {
        switch (this.getAlignment()) {
            case 2: {
                return 85;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 50;
            }
        }
        return 50;
    }

    private int getUpdatedLocation() {
        switch (this.getAlignment()) {
            case 2: {
                return 100;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 50;
            }
        }
        return 50;
    }

    public Point getOffset() {
        return this.offset;
    }

    protected PointList getPointList() {
        if (this.parent instanceof Connection) {
            return ((Connection)this.parent).getPoints();
        }
        PointList ptList = new PointList();
        ptList.addPoint(this.parent.getBounds().getLocation());
        return ptList;
    }

    public Point getReferencePoint() {
        if (this.parent instanceof Connection) {
            NamedStyle style = this.view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), IS_UPDATED_POSITION);
            Boolean updated = style == null ? false : (Boolean)style.eGet((EStructuralFeature)NotationPackage.eINSTANCE.getBooleanValueStyle_BooleanValue());
            return this.getConnectionReferancePoint(updated);
        }
        return this.parent.getBounds().getLocation();
    }

    public Point getConnectionReferancePoint(boolean updated) {
        PointList ptList = ((Connection)this.parent).getPoints();
        return PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)(updated ? this.getUpdatedLocation() : this.getLocation()), (boolean)true);
    }

    public Dimension getSize() {
        return this.extent.getCopy();
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void relocate(IFigure target) {
        Dimension size = new Dimension();
        if (this.extent != null) {
            PapyrusLabelLocator currentConstraint = (PapyrusLabelLocator)((Object)target.getParent().getLayoutManager().getConstraint(target));
            Dimension currentExtent = currentConstraint.getSize();
            size = new Dimension(currentExtent);
            if (currentExtent.width == -1) {
                size.width = target.getPreferredSize().width;
            }
            if (currentExtent.height == -1) {
                size.height = target.getPreferredSize().height;
            }
            target.setSize(size);
        } else {
            target.setSize(new Dimension(target.getPreferredSize().width, target.getPreferredSize().height));
        }
        Point location = null;
        location = PapyrusLabelHelper.relativeCoordinateFromOffset(target, this.getReferencePoint(), this.offset);
        switch (this.textAlignment) {
            case 1: {
                location.translate(target.getBounds().width / 2, 0);
                break;
            }
            case 4: {
                location.translate(-target.getBounds().width / 2, 0);
                break;
            }
            case 2: {
                break;
            }
        }
        target.setLocation(location);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setMargin(Point margin) {
        this.margin = margin;
    }

    public void setOffset(Point offset) {
        this.offset = offset;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void setView(View view) {
        this.view = view;
    }
}

