/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.internal.pages;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ui.editor.Messages;
import org.eclipse.sirius.ui.editor.SessionEditor;
import org.eclipse.sirius.ui.editor.SessionEditorPlugin;
import org.eclipse.sirius.ui.editor.api.pages.AbstractSessionEditorPage;
import org.eclipse.sirius.ui.editor.api.pages.PageProviderRegistry;
import org.eclipse.sirius.ui.editor.api.pages.PageUpdateCommandBuilder;
import org.eclipse.sirius.ui.editor.internal.graphicalcomponents.GraphicalSemanticModelsHandler;
import org.eclipse.sirius.ui.tools.internal.actions.session.CloseSessionsAction;
import org.eclipse.sirius.ui.tools.internal.graphicalcomponents.GraphicalRepresentationHandler;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.internal.navigator.actions.CollapseAllAction;
import org.eclipse.ui.internal.navigator.filters.FilterActionGroup;
import org.eclipse.ui.internal.navigator.filters.SelectFiltersAction;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DefaultSessionEditorPage
extends AbstractSessionEditorPage
implements SessionListener {
    private static final String DELIMITER = "/";
    private Session session;
    private FormText informativeLabel;
    private GraphicalSemanticModelsHandler graphicalSemanticModelsHandler;
    private GraphicalRepresentationHandler graphicalRepresentationHandler;
    private CollapseAllHandler collapseAllHandler;
    private FilterActionGroup filterActionGroup;
    private SessionEditor editor;

    public DefaultSessionEditorPage(SessionEditor theEditor) {
        super((FormEditor)theEditor, "org.eclipse.sirius.ui.editor.DefaultSessionEditorPage", Messages.UI_SessionEditor_default_page_tab_label);
        this.session = theEditor.getSession();
        this.editor = theEditor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        IProject sessionProject;
        super.createFormContent(managedForm);
        ScrolledForm scrolledForm = managedForm.getForm();
        if (ResourcesPlugin.getWorkspace() != null && ResourcesPlugin.getWorkspace().getRoot() != null && this.session.getSessionResource() != null && this.session.getSessionResource().getURI() != null && !ModelingProject.hasModelingProjectNature((IProject)(sessionProject = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.session.getSessionResource().getURI().toPlatformString(true))).getProject()))) {
            this.initEditorHeaderToolbar(managedForm);
        }
        FormToolkit toolkit = managedForm.getToolkit();
        int sessionUriSegmentSize = this.session.getSessionResource().getURI().segmentsList().size();
        scrolledForm.setText(MessageFormat.format(Messages.UI_SessionEditor_header_title, this.session.getSessionResource().getURI().segmentsList().subList(1, sessionUriSegmentSize).stream().collect(Collectors.joining(DELIMITER))));
        toolkit.decorateFormHeading(scrolledForm.getForm());
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.informativeLabel = toolkit.createFormText(body, false);
        this.informativeLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.getHref().toString()));
                }
                catch (MalformedURLException | PartInitException ex) {
                    SessionEditorPlugin.getPlugin().error("An error occured while opening the external web browser.", (Exception)ex);
                }
            }
        });
        this.informativeLabel.setForeground(body.getDisplay().getSystemColor(3));
        Composite subBody = toolkit.createComposite(body);
        subBody.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).create());
        subBody.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createModelsControl(toolkit, subBody);
        Composite rightComposite = toolkit.createComposite(subBody);
        rightComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(5, 0).create());
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createRepresentationsControl(toolkit, rightComposite);
        this.session.addListener((SessionListener)this);
        scrolledForm.reflow(true);
    }

    private void initEditorHeaderToolbar(IManagedForm managedForm) {
        CloseSessionsAction closeSessionsAction = new CloseSessionsAction(Messages.DefaultSessionEditorPage_closeSession_action_label, this.session);
        closeSessionsAction.setToolTipText(Messages.DefaultSessionEditorPage_closeSession_action_tooltip);
        managedForm.getForm().getToolBarManager().add((IAction)closeSessionsAction);
        managedForm.getForm().getToolBarManager().update(true);
    }

    protected void createModelsControl(FormToolkit toolkit, Composite subBody) {
        Section modelSection = toolkit.createSection(subBody, 256);
        modelSection.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        modelSection.setLayoutData((Object)new GridData(4, 4, false, false));
        modelSection.setText(Messages.UI_SessionEditor_models_title);
        Composite modelSectionClient = toolkit.createComposite((Composite)modelSection, 0);
        modelSectionClient.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        modelSectionClient.setLayoutData((Object)new GridData(4, 4, false, false));
        modelSection.setClient((Control)modelSectionClient);
        this.graphicalSemanticModelsHandler = new GraphicalSemanticModelsHandler(this.session, toolkit, ((IEditorSite)this.editor.getSite()).getActionBars(), ((IEditorSite)this.editor.getSite()).getSelectionProvider(), (IWorkbenchSite)this.getSite());
        this.graphicalSemanticModelsHandler.createControl(modelSectionClient);
        this.getSite().setSelectionProvider((ISelectionProvider)this.graphicalSemanticModelsHandler.getTreeViewer());
        this.initModelSectionToolbar(modelSection, this.graphicalSemanticModelsHandler.getTreeViewer());
    }

    private void initModelSectionToolbar(Section section, CommonViewer treeViewer) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        INavigatorViewerDescriptor viewerDescriptor = treeViewer.getNavigatorContentService().getViewerDescriptor();
        boolean hideCollapseAllAction = viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideCollapseAllAction");
        if (!hideCollapseAllAction) {
            CollapseAllAction collapseAllAction = new CollapseAllAction(treeViewer);
            collapseAllAction.setToolTipText(Messages.DefaultSessionEditorPage_collapseAllAction_tooltip);
            ImageDescriptor collapseAllIcon = this.getImageDescriptor("collapseall.png");
            collapseAllAction.setImageDescriptor(collapseAllIcon);
            collapseAllAction.setHoverImageDescriptor(collapseAllIcon);
            this.collapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)treeViewer);
            toolBarManager.add((IAction)collapseAllAction);
        }
        this.filterActionGroup = new FilterActionGroup(treeViewer);
        SelectFiltersAction selectFiltersAction = new SelectFiltersAction(treeViewer, this.filterActionGroup);
        selectFiltersAction.setToolTipText(Messages.DefaultSessionEditorPage_selectFilterAction_tooltip);
        ImageDescriptor selectFiltersIcon = this.getImageDescriptor("filter_ps.png");
        selectFiltersAction.setImageDescriptor(selectFiltersIcon);
        selectFiltersAction.setHoverImageDescriptor(selectFiltersIcon);
        toolBarManager.add((IAction)selectFiltersAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected final ImageDescriptor getImageDescriptor(String relativePath) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui.editor", (String)("icons/" + relativePath));
    }

    protected void createRepresentationsControl(FormToolkit toolkit, Composite rightComposite) {
        Section representationSection = toolkit.createSection(rightComposite, 256);
        representationSection.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        representationSection.setLayoutData((Object)new GridData(4, 4, true, true));
        representationSection.setText(MessageFormat.format(Messages.UI_SessionEditor_representation_title, new Object[0]));
        Composite representationSectionClient = toolkit.createComposite((Composite)representationSection, 0);
        representationSectionClient.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        representationSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        representationSection.setClient((Control)representationSectionClient);
        GraphicalRepresentationHandler.GraphicalRepresentationHandlerBuilder graphicalRepresentationHandlerBuilder = new GraphicalRepresentationHandler.GraphicalRepresentationHandlerBuilder(this.session);
        this.graphicalRepresentationHandler = graphicalRepresentationHandlerBuilder.activateBrowserWithViewpointAndRepresentationDescriptionInformation().activateGroupingByCheckbox().activateRepresentationAndViewpointControls().useToolkitToCreateGraphicComponents(toolkit).activateShowDisabledViewpointsCheckbox().build();
        this.graphicalRepresentationHandler.createControl(representationSectionClient);
        this.graphicalRepresentationHandler.initInput();
    }

    public void doSave(final IProgressMonitor monitor) {
        if (this.session != null) {
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    DefaultSessionEditorPage.this.session.save(monitor);
                }
            });
        }
    }

    public boolean isDirty() {
        return this.session != null && this.session.getStatus() == SessionStatus.DIRTY;
    }

    public void notify(int changeKind) {
        switch (changeKind) {
            case 3: {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSessionEditorPage.this.getManagedForm().commit(true);
                        DefaultSessionEditorPage.this.getManagedForm().dirtyStateChanged();
                    }
                });
                break;
            }
            case 2: {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSessionEditorPage.this.getManagedForm().dirtyStateChanged();
                    }
                });
                break;
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.session != null) {
            this.session.removeListener((SessionListener)this);
            this.session = null;
        }
        if (this.graphicalSemanticModelsHandler != null) {
            this.graphicalSemanticModelsHandler.dispose();
            this.graphicalSemanticModelsHandler = null;
        }
        if (this.graphicalRepresentationHandler != null) {
            this.graphicalRepresentationHandler.dispose();
            this.graphicalRepresentationHandler = null;
        }
        if (this.collapseAllHandler != null) {
            this.collapseAllHandler.dispose();
            this.collapseAllHandler = null;
        }
        if (this.filterActionGroup != null) {
            this.filterActionGroup.dispose();
            this.filterActionGroup = null;
        }
    }

    @Override
    public Optional<String> getLocationId() {
        return Optional.empty();
    }

    @Override
    public Optional<PageProviderRegistry.PositioningKind> getPositioning() {
        return Optional.empty();
    }

    @Override
    public Optional<PageUpdateCommandBuilder.PageUpdateCommand> resourceSetChanged(ResourceSetChangeEvent resourceSetChangeEvent) {
        return Optional.empty();
    }

    @Override
    public Optional<PageUpdateCommandBuilder.PageUpdateCommand> pageChanged(boolean isVisible) {
        return Optional.empty();
    }
}

